<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEstComprasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('est_Compras')) {
            Schema::create('est_Compras', function (Blueprint $table) {
                $table->integer('idCompra');
                $table->integer('idOrigem');
                $table->string('stTipoOrigem', 1);
                $table->integer('idDestino');
                $table->string('stTipoDestino', 1);
                $table->dateTime('dtData');
                $table->string('stOperador', 30);
                $table->dateTime('dtUltimaAlteracao');
                $table->string('stOperadorUltimaAlteracao', 30);
                $table->boolean('flAtivo');
                $table->string('stStatus', 1);
                $table->text('stOBS')->nullble(true);
                $table->dateTime('dtAlteracao');

            });

        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('est_Compras');

    }
}
