<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CreateFinanceiroEntradasView extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::statement($this->dropView());
        DB::statement($this->createView());
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement($this->dropView());
    }

    private function createView()
    {
        return 'create view financeiro_entradas as
           select idConta as id, r.idCliente, c.stCliente as cliente, dtVencimento as vencimento,
           vrDocumento as valor, stDocumento as documento, r.flAtivo as ativo, flRecebido as recebido

            from fin_ContasReceber r
            inner join dlv_Clientes c on c.idCliente = r.idCliente';
    }
    /**
     * Reverse the migrations.
     *
     * @return string
     */
    private function dropView()
    {
        return "if exists(select 1 from sys.views where name='financeiro_entradas' and type='v')
                drop view financeiro_entradas;";
    }
}
