<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Carbon\Carbon;

class CreatePrdPerguntas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('prd_Perguntas')) {
            Schema::create('prd_Perguntas', function (Blueprint $table) {
                $table->id('idPergunta');
                $table->string('stPergunta', 255)->default('');
                $table->boolean('flObrigatoria')->default(1);
                $table->unsignedInteger('minOpcoes')->default(1);
                $table->unsignedInteger('maxOpcoes')->default(1);
                $table->dateTime('dtAlteracao')->default(DB::raw('GETDATE()'));
                $table->boolean('flAtivo')->default(1);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prd_Perguntas');
    }
}
