<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMtImpressoesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('mt_Impressoes')) {

            DB::statement('CREATE TABLE [dbo].[mt_Impressoes](
                  [dtAlteracao] [datetime] NOT NULL CONSTRAINT [DF_mt_Impressoes_dtAlteracao]  DEFAULT (getdate()),
                  [idImpressao] [int] NOT NULL,
                  [dtData] [datetime] NOT NULL CONSTRAINT [DF_mt_Impressoes_dtData]  DEFAULT (getdate()),
                  [stImpressao] [text] NOT NULL,
                  [idImpressora] [int] NOT NULL,
                  [idTerminal] [nvarchar](20) NOT NULL,
                  [flPrinted] [bit] NOT NULL CONSTRAINT [DF_mt_Impressoes_flPrinted]  DEFAULT ((0)),
                  CONSTRAINT [PK_mt_Impressoes] PRIMARY KEY CLUSTERED
                    (
                      [idImpressao] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mt_Impressoes');

    }
}
