<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMtItensLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('mt_Itens_Log')) {

            DB::statement('CREATE TABLE [dbo].[mt_Itens_Log](
                  [dtAlteracao] [datetime] NOT NULL,
                  [idLog] [bigint] NOT NULL,
                  [idComanda] [smallint] NOT NULL,
                  [idProduto] [int] NOT NULL,
                  [nrQuantidadeAnterior] [decimal](9, 3) NOT NULL,
                  [nrQuantidadeAtual] [decimal](9, 3) NOT NULL,
                  [idMicroterminal] [nvarchar](15) NOT NULL,
                  CONSTRAINT [PK_mt_Itens_Log] PRIMARY KEY CLUSTERED
                    (
                      [idLog] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mt_Itens_Log');

    }
}
