<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MobyoPaymentsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (!DB::table('mobyo_payments')->count()) {
            //IFOOD
            DB::table('mobyo_payments')->insert([
                'name' => 'default',
                'idMobyoConfig' => 1,
                'idFormaPagamento' => 1,
            ]);

            //EPADOCA
            DB::table('mobyo_payments')->insert([
                'name' => 'money',
                'idMobyoConfig' => 2,
                'idFormaPagamento' => 1,
            ]);
            DB::table('mobyo_payments')->insert([
                'name' => 'pos',
                'idMobyoConfig' => 2,
                'idFormaPagamento' => 2,
            ]);

            //ANOTEAKI
            DB::table('mobyo_payments')->insert([
                'name' => 'default',
                'idMobyoConfig' => 4,
                'idFormaPagamento' => 1,
            ]);
            DB::table('mobyo_payments')->insert([
                'name' => 'voucher',
                'idMobyoConfig' => 4,
                'idFormaPagamento' => 2,
            ]);
            DB::table('mobyo_payments')->insert([
                'name' => 'debit',
                'idMobyoConfig' => 4,
                'idFormaPagamento' => 2,
            ]);
            DB::table('mobyo_payments')->insert([
                'name' => 'credit',
                'idMobyoConfig' => 4,
                'idFormaPagamento' => 2,
            ]);
            DB::table('mobyo_payments')->insert([
                'name' => 'wallet',
                'idMobyoConfig' => 4,
                'idFormaPagamento' => 2,
            ]);

            //MOBYO
            DB::table('mobyo_payments')->insert([
                'name' => 'default',
                'idMobyoConfig' => 5,
                'idFormaPagamento' => 1,
            ]);
            DB::table('mobyo_payments')->insert([
                'name' => 'voucher',
                'idMobyoConfig' => 5,
                'idFormaPagamento' => 2,
            ]);
            DB::table('mobyo_payments')->insert([
                'name' => 'debit',
                'idMobyoConfig' => 5,
                'idFormaPagamento' => 2,
            ]);
            DB::table('mobyo_payments')->insert([
                'name' => 'credit',
                'idMobyoConfig' => 5,
                'idFormaPagamento' => 2,
            ]);
            DB::table('mobyo_payments')->insert([
                'name' => 'wallet',
                'idMobyoConfig' => 5,
                'idFormaPagamento' => 2,
            ]);
        }

        if(!DB::table('mobyo_payments')->where('name', 'cash')->count()) {
            $idMobyoConfig = $this->getIdZedelivery();

            //ZEDELIVERY
            DB::table('mobyo_payments')->insert([
                'name' => 'cash',
                'idMobyoConfig' => intval($idMobyoConfig->id),
                'idFormaPagamento' => 1,
            ]);
            DB::table('mobyo_payments')->insert([
                'name' => 'credit_card',
                'idMobyoConfig' => intval($idMobyoConfig->id),
                'idFormaPagamento' => 2,
            ]);
            DB::table('mobyo_payments')->insert([
                'name' => 'zedelivery',
                'idMobyoConfig' => intval($idMobyoConfig->id),
                'idFormaPagamento' => 2,
            ]);
        }

        $idIfoodMercado = $this->getIdIfoodMercado();
        if(!DB::table('mobyo_payments')->where('idMobyoConfig', $idIfoodMercado)->count()) {
            //IFOOD MERCADO
            DB::table('mobyo_payments')->insert([
                'name' => 'default',
                'idMobyoConfig' => $idIfoodMercado,
                'idFormaPagamento' => 1,
            ]);
        }
    }

    private function getIdZedelivery()
    {
        $id = db::table('mobyo_config')->select('id')->where('engine', 'ZEDELIVERY')->first();
        return $id;
    }
    private function getIdIfoodMercado()
    {
        $result = db::table('mobyo_config')->select('id')->where('engine', 'IFOOD MERCADO')->first();
        return intval($result->id);
    }
}
