<link href="resources/css/bootstrap.min.css" rel="stylesheet" />
<link href="resources/css/datatables.min.css" rel="stylesheet" type="text/css" />
<link href="resources/css/toastr.css" rel="stylesheet" />
<link href="resources/css/sweetalert2.css" rel="stylesheet" />
<link href="resources/css/custom.css" rel="stylesheet" />
<link href="resources/css/mobyo.css" rel="stylesheet" />

<?php

error_reporting(-1);

require_once "functions.php";
require_once "mobyoApiHelper.php";

if (strstr($_SERVER['SCRIPT_NAME'], "index.php") === false) {
    redirect("index.php");
    die;
}

permission(59);

$idAtendimento = ($_POST['id'] ? $_POST['id'] : $_GET['id']);
$flClienteRetira = ($_POST['flClienteRetira'] == "true" ? 1 : 0);

$res = mssql_query("SELECT * FROM dlv_Atendimentos WHERE idAtendimento = '$idAtendimento'");
$atendimento = mssql_fetch_array($res);

$res = mssql_query("SELECT * FROM dlv_Clientes WHERE idCliente = '$atendimento[idCliente]'");
$cliente = mssql_fetch_array($res);

$res = mssql_query("SELECT * FROM dlv_CEPs WHERE idCEP = '$cliente[idCEP]'");
$endereco = mssql_fetch_array($res);

$res = mssql_query("SELECT * FROM dlv_Config WHERE idDelivery = '$_SERVER[REMOTE_ADDR]'");
$config = mssql_fetch_array($res);

$address = [
    "city" => $endereco['stCidade'],
    "complement" => "",
    "neighborhood" => $endereco['stBairro'],
    "country" => "Brazil",
    "postalCode" => $endereco['stCEP'],
    "state" => $endereco['stEstado'],
    "streetName" => $endereco['stEndereco'],
    "streetNumber" => $cliente['nrNumero']
];

$applyMobyoEntregas = true;
$previewOnline = [];
$previewOffline = [];
$convenienceFees = 0;
$convenienceFeesOnlyPix = false;

if (!$flClienteRetira) {
    $previewOnline = MobyoApiHelper::preview($address, true);
    /*dd($previewOnline);*/
    $previewOffline = MobyoApiHelper::preview($address);
    $applyMobyoEntregas = $previewOffline['item'] && $previewOnline['item'];

    $fees = MobyoApiHelper::getConvenienceFees()['items'][0]['fees'];
    $convenienceFees = $fees['active'] ? $fees['amount'] : 0;
    $convenienceFeesOnlyPix = $fees['onlyPix'];
}

$edit = $_GET['edit'];
$subTotal = (float)$_POST['vrTotal'];
$stObsGeral = strlen(htmlspecialchars(strtoupper(trim($_POST['stObsGeral'])), ENT_QUOTES)) > 0 ? htmlspecialchars(strtoupper(trim($_POST['stObsGeral'])), ENT_QUOTES) : NULL;
$flAgendarPedido = $_POST['flAgendarPedido'];

$merchantDeliveryFee = $config['flTaxaEntregaUnica'] ?  $config['vrTaxaEntregaUnica'] : $cliente['vrEntrega'];

$nrPedido = 0;

if ($flAgendarPedido) {
    $res = mssql_query("SELECT * FROM dlv_Atendimentos WHERE idAtendimento = '$idAtendimento'");
    $arr = mssql_fetch_array($res);

    $dtAgendaOld = $arr['dtAgendarPedido'];

    $res = mssql_query("SELECT * FROM dlv_DatasEspeciais");

    while ($arr = mssql_fetch_array($res)) {
        $dtDataEspecial = date("Y-m-d", strtotime($arr['dtDataEspecial']));
        $dtAgenda = date("Y-m-d", strtotime($dtAgendarPedido));

        if ($dtDataEspecial == $dtAgenda && $dtAgenda != $dtAgendaOld) {
            $res2 = mssql_query("SELECT * FROM dlv_Atendimentos WHERE idAtendimento = '$idAtendimento'");
            $arr2 = mssql_fetch_array($res2);
            if ($arr2['nrPedido'] != 0) {
                $nrPedido = intval($arr['nrPedidoDelivery']);
                mssql_query("UPDATE dlv_DatasEspeciais SET nrPedidoDelivery = (nrPedidoDelivery) WHERE idDataEspecial = '$arr[idDataEspecial]'");
            } else {
                $nrPedido = intval($arr['nrPedidoDelivery']) + 1;
                mssql_query("UPDATE dlv_DatasEspeciais SET nrPedidoDelivery = (nrPedidoDelivery + 1) WHERE idDataEspecial = '$arr[idDataEspecial]'");
            }
        }
    }
}

mssql_query("UPDATE dlv_Atendimentos SET stOBS='$stObsGeral', flAgendarPedido='$flAgendarPedido', dtAgendarPedido='$dtAgendarPedido', dtAgendarPedidoProducao='$dtAgendarPedidoProducao', nrPedido='$nrPedido', flClienteRetira='$flClienteRetira' WHERE idAtendimento = '$idAtendimento'");

?>



<form id="confirmForm" method="post" action="index.php?sec=finalizarComMobyo">
    
    <div class="row" id="TITULO">
        <span class="column" id="pgg"><h1>PAGAMENTO E ENVIO</h1></span>
        <span class="column" id="vlrvnd"><h1>VALOR DA VENDA</h1></span>
    </div>


        <div class="row">
            <div class="column" id="coluna1">
                <span><h3>FORMA DE PAGAMENTO</h3></span>
                <select name="paymentMethod" id="paymentMethod" class="payment-method-select" required>
                    <option value="PIX">PIX</option>
                    <option value="CASH">DINHEIRO</option>
                    <option value="DEBIT">DEBITO</option>
                    <option value="CREDIT">CREDITO</option>
                </select>
                <br>
                    <span id="ENTREGA"><h3>ENTREGA</h3></span>
                    <? if (!$flClienteRetira) { ?>
                    <div class="delivey-type">
                        <select id="deliveryType" name="deliveryType" class="delivey-type-select" required>
                            <? if ($applyMobyoEntregas) { ?>
                                <option value="MOBYO ENTREGAS">MOBYO ENTREGAS</option>
                            <? } ?>
                            <option value="MERCHANT">LOJA</option>
                        </select>
                    </div>
                <? } ?>
                <? if ($flClienteRetira) { ?>
                    <span class="takeout-area">
                        <h3>O Cliente ira retirar esse pedido!</h3>
                    </span>
                <? } ?>
            </div>
                <div class="sub-total" id="coluna2">
                    <span class="sub-total-text">SUB-TOTAL: R$ <?= number_format($subTotal, 2) ?></span>
                    <br>
                    <span class="sub-total-text">DESCONTO: R$ <span id="discount">0.00</span></span>
                    <br>
                    <? if (!$flClienteRetira) { ?>
                        <span class="sub-total-text">TAXA DE ENTREGA: R$ <span id="deliveryFeeText"><?= $previewOnline['item']['deliveryFee'] ?? $merchantDeliveryFee ?></span></span>
                        <? } ?>
                    <br>
                    <span class="sub-total-text">TAXA DE CONVENIÊNCIA: <span id="convenienceFeesText"><?= number_format($convenienceFees, 2) ?></span></span>
                    <span class="sub-total-text"><h1>TOTAL: R$ <span id="subTotalFinal">0.00</span></h1></span>
                </div>     
        </div>
            <input type="hidden" name="orderType" value="<?= $flClienteRetira ? 'takeout' : 'delivery' ?>">
            <input type="hidden" name="orderId" value="<?= $idAtendimento ?>">
            <input type="hidden" id="deliveryFee" name="deliveryFee" value="<?= $previewOnline['item']['deliveryFee'] ?>" />
            <input type="hidden" id="convenienceFees" name="convenienceFees" value="<?= $convenienceFees ?>" />
            <input type="hidden" id="stObsGeral" name="stObsGeral" value="<?= $stObsGeral ?>" />
            
    
    <div class="btn-confirm-order-area">
        <button type="submit" class="btn-confirm-order">FINALIZAR</button>
    </div>
    
    <div id="VOLTAR">
        <a id="VLTR" href="index.php?sec=montarPedido&id=<?php echo $idAtendimento; ?>">VOLTAR</a>
    </div>

    <img id="logo" src="/images/LOGO_MOBYO_PRETA.jpg">
</form>

<script>
    const isTakeout = Number("<?= $flClienteRetira ?>") == 1;
    const subTotal = Number("<?= $subTotal ?>");
    const deliveryFeeOffline = Number("<?= $previewOffline['item']['deliveryFee'] ?>")
    const deliveryFeeOnline = Number("<?= $previewOnline['item']['deliveryFee'] ?>")
    const deliveryType = document.getElementById('deliveryType')
    const paymentMethod = document.getElementById('paymentMethod')
    const merchantDeliveryFee = Number("<?= $merchantDeliveryFee ?>")
    const convenienceFees = Number("<?= $convenienceFees ?>")
    const convenienceFeesOnlyPix = Boolean("<?= $convenienceFeesOnlyPix ?>")

    function calculateFee() {
        const isMobyoEntregas = deliveryType?.value == 'MOBYO ENTREGAS';
        const isPaymentPix = paymentMethod.value == 'PIX';
        const discount = isPaymentPix ? deliveryFeeOffline - deliveryFeeOnline : 0;
        const deliveryFee = !isTakeout ? (isMobyoEntregas ? deliveryFeeOffline - discount : merchantDeliveryFee) : 0;
        const additionalFees = !isTakeout && (!convenienceFeesOnlyPix || (convenienceFeesOnlyPix && !isPaymentPix)) ? convenienceFees : 0;

        document.getElementById('deliveryFee').value = deliveryFee;
        document.getElementById('convenienceFees').value = additionalFees;

        if (document.getElementById('deliveryFeeText')?.innerText) {
            document.getElementById('deliveryFeeText').innerHTML = isMobyoEntregas ? (isPaymentPix ? `<s>${deliveryFeeOffline}</s> ${deliveryFee.toFixed(2)}` : deliveryFeeOffline.toFixed(2)) : merchantDeliveryFee.toFixed(2);
        }

        document.getElementById('convenienceFeesText').innerHTML = additionalFees.toFixed(2);
        document.getElementById('subTotalFinal').innerHTML = ((subTotal + deliveryFee) + (additionalFees)).toFixed(2);
    }

    paymentMethod?.addEventListener('change', e => calculateFee());
    deliveryType?.addEventListener('change', e => calculateFee());

    calculateFee();
</script>