<?php
require_once "../model/grupoDao.class.php";
require_once "../model/subGrupoDao.class.php";
require_once "../model/contaDao.class.php";
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of contasReceberService
 *
 * @author kid
 */
class ContasReceberService {
    
    //---------- [VARI�VEIS] ---------------------------------------------------
    
    private $grupoDao;
    private $subGrupoDao;
    private $contaDao;
    
    //---------- [CONSTRUTORES] ------------------------------------------------
    
    /**
     * Construtor default.
     */
    public function __construct() {
        $this->grupoDao = new GrupoDao();
        $this->subGrupoDao = new SubGrupoDao();
        $this->contaDao = new ContaDao;
    }
    
    //---------- [M�TODOS] -----------------------------------------------------
    
    /**
     * M�todo de servi�o respons�vel por listar todos os Grupos.
     * 
     * @return array Retorna um array de objetos de Grupo.
     */
    public function listarGrupos() {
        return $this->grupoDao->listarGruposEntrada();
    }
    
    /**
     * M�todo de servi�o respons�vel por listar todos os SubGrupos de um 
     * determinado Grupo.
     * 
     * @param int $grupoId O id do Grupo, do qual se deseja buscar os SubGrupos.
     * 
     * @return array Retorna um array de objetos de SubGrupo.
     */
    public function listarSubGruposPorGrupo($grupoId) {
        $grupos = array();
        foreach ($this->subGrupoDao->buscarPorGrupo((int)$grupoId) as $grupo) {
            if ($grupo['flEntrada'] == 1) {
                array_push($grupos, $grupo);
            }
        }
        return $grupos;
    }
    
    /**
     * M�todo de servi�o respons�vel por listar todas as Contas de um 
     * determinado SubGrupo.
     * 
     * @param int $subGrupoId O id do SubGrupo, do qual se deseja buscar as 
     * Contas.
     * 
     * @return array Retorna um array de objetos de Conta.
     */
    public function listarContaPorSubGrupo($subGrupoId) {
        return $this->contaDao->buscarContaPorSubGrupo($subGrupoId);
    }

    /**
     * M�todo respons�vel por fazer uma chamada HTTP para a API do Laravel
     * no recurso /invoice, passando o id da conta.
     *
     * @param int $id O id da conta para o qual se deseja gerar a fatura.
     */


    public function invoice($id) {
        
        

    }
}
?>
