<?php

require_once "functions.php";

class MobyoApiHelper
{
    private static $baseUrl = "https://api.mobyo.com.br";
    // private static $baseUrl = "https://6451fad49b1e8919575ea241f0304673.loophole.site";
    // private static $baseUrl = "http://192.168.0.56:8080";

    private static function buildToken()
    {
        $token = mssql_fetch_array(mssql_query("SELECT * FROM Master"))['mobyoToken'];
        return base64_encode(str_contains($token, ":") ? $token : $token . ":");
    }

    private static function buildHeaders(array $custonHeaders)
    {
        $headers = [
            "Content-Type: application/json",
            "x-app: Basic MTcxMDE4MTU0NDIyNDMyRjhCN0E0QTZCMzQ4QTE4Mzg6ZTlhMTJiZDhmNjE4NmJkYWYwNGE2Y2I0NDk2NGQ5NTk5NGVhNzBkZGMyMzg3NDdjZGQ2YzllNzg0MzRjYWU3NQ==",
            "Authorization: Basic " . MobyoApiHelper::buildToken(),
        ];

        return array_merge($headers, $custonHeaders);
    }

    private static function request(string $endpoint, string $method, array $params = [], array $body = [], array $headers = [])
    {
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => MobyoApiHelper::$baseUrl . $endpoint . '?' . http_build_query($params),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_POSTFIELDS => $body ? json_encode($body) : null,
            CURLOPT_HTTPHEADER => MobyoApiHelper::buildHeaders($headers),
        ]);

        $response = curl_exec($curl);
        return json_decode($response, true);
    }

    public static function preview(array $address, bool $onlinePayment = false)
    {
        return MobyoApiHelper::request("/mottu/preview", "POST", ["onlinePayment" => $onlinePayment ? 'true' : 'false'], $address);
    }

    public static function createOrder(array $order)
    {
        return MobyoApiHelper::request("/v3/orders/nati-v1", "POST", [], $order);
    }

    public static function getOrder(string $orderId)
    {
        return MobyoApiHelper::request("/v3/orders/$orderId", "GET");
    }

    public static function updateOrder(array $order)
    {
        return MobyoApiHelper::request("/v3/orders/nati-v1", "PATCH", [], $order);
    }

    public static function cancelOrder(string $orderId, string $reason)
    {
        $cancelCode = "801";
        $cancelText = $reason;
        return MobyoApiHelper::request("/v3/orders/$orderId/status/cancelled", "PATCH", [], [
            "cancelCode" => $cancelCode,
            "cancelText" => $cancelText,
        ]);
    }

    public static function getConvenienceFees()
    {
        return MobyoApiHelper::request("/engines/by-type/NATI", "GET");
    }
}
