<?php
header('Content-type: application/json');

chdir(dirname(realpath(__FILE__)));
require_once "../../../functions.php";
require_once "../../../database/models/CxCaixaLoginClose.class.php";
db_conn();

// var_dump($_GET);
$start = $_GET['start'];
$length = $_GET['length'];
$search = $_GET['search'];
$order = $_GET['order'][0];
$turno = $_GET['turno'];
if ($order) {
	$orderColumn = $order['column'];
	switch ($orderColumn) {
		case 0:
		$orderColumn = "g.idAbertura";
		break;
		case 1:
		$orderColumn = "g.dtFechamento";
		break;
		case 2:
		$orderColumn = "g.idCaixa";
		break;
		case 3:
		$orderColumn = "o.stApelido";
		break;
		case 4:
		$orderColumn = "SUM(p.vrFormaPagamento)";
		break;
		case 5:
		$orderColumn = "g.dtAbertura";
		break;
		case 6:
		$orderColumn = "g.dtFechamento";
		break;
	}
	$orderDirection = strtoupper($order['dir']);
}

if ($search) {
	$searchValue = $search['value'];
	$searchLength = strlen($searchValue);
}

if ($turno == 0) {
//QUERY DE TOTAL DE FECHAMENTOS
	$qry = "SELECT COUNT(DISTINCT idAbertura) FROM cx_Gerenciador
	WHERE flAberto = '0' AND flConferencia = '0'";
	$res = mssql_fetch_array(mssql_query($qry));
	$rows['recordsTotal'] = $res[0];


//QUERY DE TOTAL DE FECHAMENTOS FILTRADOS
	$qry = "SELECT COUNT(DISTINCT g.idAbertura) FROM cx_Gerenciador g
	INNER JOIN op_Operadores o ON g.idOperador = o.idOperador
	WHERE g.flAberto = '0' AND g.flConferencia = '0'";
	if($searchLength > 0){
		if (ctype_digit($searchValue)) {
			$qry .= "AND LEFT(g.idAbertura, ".$searchLength.") LIKE '".$searchValue."%'";
		}else{
			$qry .= "AND o.stApelido LIKE '".$searchValue."%'";
		}
	}
	$res = mssql_fetch_array(mssql_query($qry));
	$rows['recordsFiltered'] = $res[0];


//QUERY DE BUSCA DE FECHAMENTOS
	$qry = "DECLARE @page INT = ".($start/$length)."
	DECLARE @perPage INT = ".$length."

	SELECT idAbertura, idCaixa, idOperador, stApelido, dtFechamento, dtAbertura FROM
	(
	SELECT ROW_NUMBER() OVER (ORDER BY ".$orderColumn." ".$orderDirection.") AS RowNum, g.idAbertura, g.idCaixa, o.idOperador, o.stApelido, g.dtFechamento, 
	g.dtAbertura 
	FROM cx_Gerenciador g 
	INNER JOIN op_Operadores o ON g.idOperador = o.idOperador
	WHERE g.flAberto = '0' AND g.flConferencia = '0' ";
	if($searchLength > 0){
		if (ctype_digit($searchValue)) {
			$qry .= "AND LEFT(g.idAbertura, ".$searchLength.") LIKE '".$searchValue."%'";
		}else{
			$qry .= "AND o.stApelido LIKE '".$searchValue."%'";
		}
	}
	$qry .="GROUP BY g.idAbertura, g.idCaixa, o.idOperador, o.stApelido, g.dtFechamento, g.dtAbertura";
	$qry .= ") AS fechamentos WHERE RowNum >= (@page)* @perPage AND RowNum <= ((@page)* @perPage)+@perPage";
}else{

//QUERY DE PEGAR O HORARIO DO TURNO
	$qryTurnos = "SELECT * FROM cx_turnosCaixas WHERE idTurno = ". $turno;
	$resTurno = mssql_query($qryTurnos);
	$arrTurno = mssql_fetch_assoc($resTurno);
	$time = "BETWEEN '". $arrTurno['hrInicio']. "' AND '". $arrTurno['hrFim']."' ";

	//QUERY DE TOTAL DE FECHAMENTOS
	$qry = "SELECT COUNT(DISTINCT idAbertura) FROM cx_Gerenciador
	WHERE flAberto = '0' AND flConferencia = '0' AND CAST(dtAbertura as time) ". $time;
	$res = mssql_fetch_array(mssql_query($qry));
	$rows['recordsTotal'] = $res[0];


//QUERY DE TOTAL DE FECHAMENTOS FILTRADOS
	$qry = "SELECT COUNT(DISTINCT g.idAbertura) FROM cx_Gerenciador g
	INNER JOIN op_Operadores o ON g.idOperador = o.idOperador
	WHERE g.flAberto = '0' AND g.flConferencia = '0'  AND CAST(g.dtAbertura as time) ". $time;
	if($searchLength > 0){
		if (ctype_digit($searchValue)) {
			$qry .= "AND LEFT(g.idAbertura, ".$searchLength.") LIKE '".$searchValue."%'";
		}else{
			$qry .= "AND o.stApelido LIKE '".$searchValue."%'";
		}
	}
	$res = mssql_fetch_array(mssql_query($qry));
	$rows['recordsFiltered'] = $res[0];


//QUERY DE BUSCA DE FECHAMENTOS
	$qry = "DECLARE @page INT = ".($start/$length)."
	DECLARE @perPage INT = ".$length."

	SELECT idAbertura, idCaixa, idOperador, stApelido, dtFechamento, dtAbertura FROM
	(
	SELECT ROW_NUMBER() OVER (ORDER BY ".$orderColumn." ".$orderDirection.") AS RowNum, g.idAbertura, g.idCaixa, o.idOperador, o.stApelido, g.dtFechamento, 
	g.dtAbertura
	FROM cx_Gerenciador g 
	INNER JOIN op_Operadores o ON g.idOperador = o.idOperador
	WHERE g.flAberto = '0' AND g.flConferencia = '0' AND CAST(g.dtAbertura as time) ". $time ;
	if($searchLength > 0){
		if (ctype_digit($searchValue)) {
			$qry .= " AND LEFT(g.idAbertura, ".$searchLength.") LIKE '".$searchValue."%'";
		}else{
			$qry .= " AND o.stApelido LIKE '".$searchValue."%'";
		}
	}
	$qry .="GROUP BY g.idAbertura, g.idCaixa, o.idOperador, o.stApelido, g.dtFechamento, g.dtAbertura";
	$qry .= ") AS fechamentos WHERE RowNum >= (@page)* @perPage AND RowNum <= ((@page)* @perPage)+@perPage";
}
$res = mssql_query($qry);
while ($arr = mssql_fetch_assoc($res)) {
	$arr['dtAbertura'] = date("d/m/Y H:i", strtotime($arr['dtAbertura']));
	$arr['dtFechamento'] = date("d/m/Y H:i", strtotime($arr['dtFechamento']));

	$qryValor = "SELECT SUM(p.vrPagamento) as vrTotal FROM (SELECT SUM(p.vrFormaPagamento) as vrPagamento
	FROM cx_FormasPagamento f LEFT JOIN cx_FichaRecebimentos_Temp p 
	ON f.idFormaPagamento = p.idFormaPagamento 
	WHERE f.idTipo NOT IN ('6', '7', '9', '12', '13', '14', '16', '17', '20') 
	AND f.flAtivo = '1' AND p.idAbertura = ". $arr['idAbertura'] ." AND p.flAtivo=1
	UNION
	SELECT null as vrPagamento FROM cx_FormasPagamento 
	WHERE idTipo NOT IN ('6', '7', '9', '12', '13', '14', '16', '17', '20')  AND flAtivo = '1' AND idFormaPagamento not IN(
	SELECT idFormaPagamento FROM cx_FichaRecebimentos_Temp WHERE idAbertura = ". $arr['idAbertura'] ." AND flAtivo = 1)) p";

	$arrVrTotal = mssql_fetch_array(mssql_query($qryValor))[0];
	if (!$arrVrTotal) {
		$arrVrTotal = 0.00;
	}
	$arr['vrTotal'] = $arrVrTotal;

	$data[] = $arr;
}
if (!$data) {
	$rows['data'] = array();	
}else{
	$rows['data'] = $data;
}

echo json_encode($rows);
?>