<?php
require_once "functions.php";
logincheck();

if (!autorization(57)) {
    header("LOCATION: index.php?sec=erro&sub=2");
    die;
}

function getTotalPendura($abertura){
    $qry = "SELECT SUM(E.vrTotal+e.vrAcrescimo+E.vrDesconto-E.vrQuitado) as vrTotal
                                            FROM cli_Extrato E
                                            INNER JOIN cx_Gerenciador g ON E.idAbertura = g.idAbertura
                                            WHERE $abertura AND E.flAtivo = '1'";
    $res = mssql_query($qry);
    $arr = mssql_fetch_array($res);
    return $arr['vrTotal'];
}

function getCancelamentos($abertura, $fd, $fl){
    // Consulta das vendas canceladas
    $sqlCancelados = "SELECT i.idCodProduto, i.idProduto, SUM(i.vrTotal) AS vrTotal FROM
                                              (SELECT * FROM cx_Itens UNION SELECT * FROM cx_Itens_Temp) i
                                            INNER JOIN cx_Gerenciador g ON i.idAbertura = g.idAbertura
                                            WHERE ($abertura) AND i.dtData BETWEEN '".$fd."' AND '".$fl."' " .
        "AND i.flAtivo = '0' AND i.idCodProduto <> '-100' GROUP BY i.idCodProduto, i.idProduto, i.vrCusto";
    $resCancelados = mssql_query($sqlCancelados);
    $totalCancelamento = 0;
    while ($arrCancelados = mssql_fetch_array($resCancelados)) {
        $totalCancelamento += $arrCancelados['vrTotal'];
    }

    return $totalCancelamento;
}
function getAcrescimo($abertura, $fd, $fl){
    $arr = mssql_fetch_array(mssql_query("
                                                    select sum(v.vrAcrescimo) as vrAcrescimo from (select vrAcrescimo, idAbertura, dtData, flAtivo from cx_Vendas_Temp UNION select vrAcrescimo, idAbertura, dtData, flAtivo from cx_Vendas) v
                                                        inner join cx_Gerenciador g on g.idAbertura = v.idAbertura WHERE ($abertura) AND v.flAtivo = '1' AND v.dtData BETWEEN '".$fd."' AND '".$fl."' "));
    return $arr['vrAcrescimo'];
}
function getDesconto($abertura, $fd, $fl){
    $qry = "select Sum(vrDesconto) as vrDesconto from(select idAbertura,vrDesconto, flAtivo, dtData from cx_Vendas UNION select idAbertura,vrDesconto, flAtivo, dtData from cx_Vendas_Temp) v
                                            inner join cx_gerenciador g on g.idabertura = v.idAbertura WHERE ($abertura) and v.flAtivo = '1' AND v.dtData BETWEEN '".$fd."' AND '".$fl."'";
    $res = mssql_query($qry);
    $arr = mssql_fetch_array($res);
   return $arr['vrDesconto'];
}

$res = mssql_query("SELECT COUNT(*) FROM cx_Gerenciador");
$arr = mssql_fetch_array($res);

if ($arr[0] < 1) {
    ?>
    <table width="100%" cellspacing="0" cellpadding="10">
        <tr>
            <td>
                <table width="100%" cellspacing="0" cellpadding="5" border="1" bordercolor="#2A98D3" style="border-collapse: collapse" bgcolor="#FFFFFF">
                    <tr>
                        <td>
                            <br>
                            <center><font size="2"><b>É necessário ao menos um fechamento de caixa para emissão deste relatório!</b></font></center>
                            <br>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    <?
} else {
    $passo1 = htmlspecialchars($_POST['passo1'], ENT_QUOTES);
    $passo2 = htmlspecialchars($_POST['passo2'], ENT_QUOTES);
    $passo3 = htmlspecialchars($_POST['passo3'], ENT_QUOTES);
    $passo4 = htmlspecialchars($_POST['passo4'], ENT_QUOTES);
    $passo5 = htmlspecialchars($_POST['passo5'], ENT_QUOTES);
    $produto = htmlspecialchars($_POST['produto'], ENT_QUOTES);
    $tipo = htmlspecialchars($_POST['tipo'], ENT_QUOTES);
    $de1 = htmlspecialchars($_POST['de1'], ENT_QUOTES);
    $ate1 = htmlspecialchars($_POST['ate1'], ENT_QUOTES);
    $de2 = htmlspecialchars($_POST['de2'], ENT_QUOTES);
    $ate2 = htmlspecialchars($_POST['ate2'], ENT_QUOTES);
    $de3 = htmlspecialchars($_POST['de3'], ENT_QUOTES);
    $ate3 = htmlspecialchars($_POST['ate3'], ENT_QUOTES);
    $dehora = htmlspecialchars($_POST['dehora'], ENT_QUOTES);
    $deminuto = htmlspecialchars($_POST['deminuto'], ENT_QUOTES);
    $atehora = htmlspecialchars($_POST['atehora'], ENT_QUOTES);
    $ateminuto = htmlspecialchars($_POST['ateminuto'], ENT_QUOTES);
    $fd = htmlspecialchars($_POST['fd'], ENT_QUOTES);
    $fl = htmlspecialchars($_POST['fl'], ENT_QUOTES);

    if (!$passo1) {
        ?>
        <table width="100%" cellspacing="0" cellpadding="10">
            <tr>
                <td>
                    <table width="100%" cellspacing="0" cellpadding="5" border="1" bordercolor="#2A98D3" style="border-collapse: collapse" bgcolor="#FFFFFF">
                        <tr>
                            <td>
                                <br>
                                <center><font size="3"><b>Filtro</b></font></center>
                                <br>
                            </td>
                        </tr>
                        <tr>
                            <form method="POST" action="?sec=relatorios&sub=faturamento" name="dateSelect">
                                <input type="hidden" name="passo1" value="true">
                                <td>
                                    <br>
                                    <center><font size="2">-- Digite o período desejado --</font></center>
                                    <br>
                                    <table align="center" border="0" cellpadding="0" cellspacing="5">
                                        <tr>
                                            <td><font size="2"><b>De:</b></font></td>
                                            <td>
                                                <input type="text" size="1" name="de1" maxlength="2" value="<?php echo  date("d") ?>" style="border: 1px solid #2A98D3;" onkeypress="return removeInvalidChars(event, '0123456789', 'false')" onblur="leftZero(event)"> /
                                                <input type="text" size="1" name="de2" maxlength="2" value="<?php echo  date("m") ?>" style="border: 1px solid #2A98D3;" onkeypress="return removeInvalidChars(event, '0123456789', 'false')" onblur="leftZero(event)"> /
                                                <input type="text" size="3" name="de3" maxlength="4" value="<?php echo  date("Y") ?>" style="border: 1px solid #2A98D3;" onkeypress="return removeInvalidChars(event, '0123456789', 'false')"> <font size="2">às</font>
                                                <input type="text" size="3" name="dehora" maxlength="2" value="00" style="border: 1px solid #2A98D3;" onkeypress="return removeInvalidChars(event, '0123456789', 'false')"> :
                                                <input type="text" size="3" name="deminuto" maxlength="2" value="00" style="border: 1px solid #2A98D3;" onkeypress="return removeInvalidChars(event, '0123456789', 'false')"> <font size="2">(dd/mm/aaaa hh:mm)</font>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><font size="2"><b>Até:</b></font></td>
                                            <td>
                                                <input type="text" size="1" name="ate1" maxlength="2" value="<?php echo  date("d") ?>" style="border: 1px solid #2A98D3;" onkeypress="return removeInvalidChars(event, '0123456789', 'false')" onblur="leftZero(event)"> /
                                                <input type="text" size="1" name="ate2" maxlength="2" value="<?php echo  date("m") ?>" style="border: 1px solid #2A98D3;" onkeypress="return removeInvalidChars(event, '0123456789', 'false')" onblur="leftZero(event)"> /
                                                <input type="text" size="3" name="ate3" maxlength="4" value="<?php echo  date("Y") ?>" style="border: 1px solid #2A98D3;" onkeypress="return removeInvalidChars(event, '0123456789', 'false')"> <font size="2">às</font>
                                                <input type="text" size="3" name="atehora" maxlength="2" value="23" style="border: 1px solid #2A98D3;" onkeypress="return removeInvalidChars(event, '0123456789', 'false')"> :
                                                <input type="text" size="3" name="ateminuto" maxlength="2" value="59" style="border: 1px solid #2A98D3;" onkeypress="return removeInvalidChars(event, '0123456789', 'false')"> <font size="2">(dd/mm/aaaa hh:mm)</font>
                                            </td>
                                        </tr>
                                    </table>
                                    <br>
                                    <center><input type="button" name="bnt" value="Avançar >>" onclick="validDate('dateSelect', document.dateSelect.de1, document.dateSelect.de2, document.dateSelect.de3, document.dateSelect.ate1, document.dateSelect.ate2, document.dateSelect.ate3)"></center>
                                </td>
                            </form>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <?
    } elseif ($passo1 && !$passo2) {
        $fd = $de3 . "-" . $de2 . "-" . $de1 . " " . $dehora . ":" . $deminuto.":00";
        $fl = $ate3 . "-" . $ate2 . "-" . $ate1 . " " . $atehora . ":" . $ateminuto.":59";
        //pega os fechamentos de caixa
        $sql = "SELECT DISTINCT G.idAbertura, G.idCaixa, G.idOperador, G.dtAbertura, G.dtFechamento, G.flAberto, O.stApelido FROM
        (SELECT idAbertura, dtData FROM cx_Vendas UNION SELECT idAbertura, dtData FROM cx_Vendas_Temp) V
        INNER JOIN cx_Gerenciador G ON V.idAbertura = G.idAbertura
        INNER JOIN op_Operadores O ON G.idOperador = O.idOperador
        WHERE V.dtData BETWEEN '$fd' AND '$fl'
        ORDER BY G.idCaixa, G.dtAbertura";

        $res = mssql_query($sql);
        $num = mssql_num_rows($res);

        if ($num > 0) {
            ?>
            <table width="100%" cellspacing="0" cellpadding="10">
                <tr>
                    <td>
                        <table width="100%" cellspacing="0" cellpadding="5" border="1" bordercolor="#2A98D3" style="border-collapse: collapse" bgcolor="#FFFFFF">
                            <tr>
                                <td>
                                    <br>
                                    <center><font size="3"><b>Filtro</b></font></center>
                                    <br>
                                </td>
                            </tr>
                            <tr>
                                <form method="POST" action="?sec=relatorios&sub=faturamento" name="filtro">
                                    <input type="hidden" name="passo1" value="true">
                                    <input type="hidden" name="passo2" value="true">
                                    <td>
                                        <br>
                                        <center><font size="2">-- Selecione o(s) caixa(s) desejado(s) --</font></center>
                                        <br>
                                        <table align="center" border="0" cellpadding="0" cellspacing="5">
                                            <tr>
                                                <td>
                                                    <?
                                                    $count = 3;
                                                    $old = 0;

                                                    while ($arr = mssql_fetch_array($res)) {
                                                        if ($old != $arr['idCaixa']) {
                                                            echo "<p style='background-color: #E2F0F9; text-align: center;'><font size='2'><b>Caixa " . str_pad($arr['idCaixa'], 2, "0", STR_PAD_LEFT) . "</b><br />[ <a href=\"javascript:selectall(true, '$arr[idCaixa]')\">Selecionar</a> ][ <a href=\"javascript:selectall(false, '$arr[idCaixa]')\">Limpar</a> ]</font></p>";
                                                            $old = $arr['idCaixa'];
                                                        }

                                                        $dtFechamento = strtotime($arr['dtFechamento']);
                                                        $dtFechamento = $arr['flAberto'] ? "EM ANDAMENTO" : date("d/m/y H:i", $dtFechamento);
                                                        $dtAbertura = strtotime($arr['dtAbertura']);
                                                        $dtAbertura = date("d/m/y H:i", $dtAbertura);

                                                        echo "<input name=idab" . $arr['idAbertura'] . " type=checkbox value=" . $arr['idAbertura'] . " checked class='grupo" . $arr['idCaixa'] . "'> <font size=2>" . $arr['stApelido'] . " [Aberto: $dtAbertura | Fechado: $dtFechamento ]</font><br>";
                                                        echo "<input type='hidden' name='" . $arr['idCaixa'] . "@idab" . $arr['idAbertura'] . "' value='idab" . $arr['idAbertura'] . "'>";

                                                        $count++;
                                                    }
                                                    ?>
                                                </td>
                                            </tr>
                                        </table>
                                        <br>
                                        <center>
                                            <input type="hidden" name="fd" value="<?php echo  $fd ?>">
                                            <input type="hidden" name="fl" value="<?php echo  $fl ?>">
                                            <input type="button" name="bnt" value="  << Voltar   " onclick="goBack();">
                                            <input type="submit" name="bnt" value="Avançar >>">
                                        </center>
                                    </td>
                                </form>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
            <SCRIPT>
                function selectall(check, caixa)
                {
                    // var obj = document.getElementsByTagName("input");

                    // for (var i=0; i<obj.length; i++)
                    // {
                    //     if (obj[i].type.toUpperCase() == "HIDDEN")
                    //     {
                    //         if (obj[i].name.indexOf(caixa+"@idab") != -1)
                    //         {
                    //             document.getElementById(obj[i].value).checked = check;
                    //         }
                    //     }
                    // }

                    $('.grupo'+caixa).prop("checked",check);

                }
            </SCRIPT>
            <?
        } else {
            ?>
            <table width="100%" cellspacing="0" cellpadding="10">
                <tr>
                    <td>
                        <table width="100%" cellspacing="0" cellpadding="5" border="1" bordercolor="#2A98D3" style="border-collapse: collapse" bgcolor="#FFFFFF">
                            <tr>
                                <td>
                                    <br>
                                    <center>
                                        <font size="2">
                                            <b>Não existe nenhum caixa no perodo informado.</b>
                                            <br><br>
                                            <a href="javascript:history.go(-1)"><b>Voltar</b></a>
                                        </font>
                                    </center>
                                    <br>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
            <?
        }
    } elseif ($passo1 && $passo2 && !$passo3) {
        ?>
        <table width="100%" cellspacing="0" cellpadding="10">
            <tr>
                <td>
                    <table width="100%" cellspacing="0" cellpadding="5" border="1" bordercolor="#2A98D3" style="border-collapse: collapse" bgcolor="#FFFFFF">
                        <tr>
                            <td>
                                <br>
                                <center><font size="3"><b>Filtro</b></font></center>
                                <br>
                            </td>
                        </tr>
                        <tr>
                            <form method="POST" action="?sec=relatorios&sub=faturamento">
                                <input type="hidden" name="passo1" value="true">
                                <input type="hidden" name="passo2" value="true">
                                <input type="hidden" name="passo3" value="true">
                                <input type="hidden" name="fd" value="<?php echo  $fd ?>">
                                <input type="hidden" name="fl" value="<?php echo  $fl ?>">
                                <?
                                $res = mssql_query("SELECT * FROM cx_Gerenciador");

                                while ($arr = mssql_fetch_array($res)) {
                                    $idAbertura = "idab" . $arr['idAbertura'];

                                    if ($_POST[$idAbertura] == $arr['idAbertura']) {
                                        echo "<input type='hidden' name='idab" . $arr['idAbertura'] . "' value='" . $arr['idAbertura'] . "'>";
                                    }
                                }
                                ?>
                                <td>
                                    <br>
                                    <center><font size="2">-- Selecione o tipo de relatório desejado --</font></center>
                                    <br>
                                    <table align="center" border="0" cellpadding="0" cellspacing="5">
                                        <tr>
                                            <td>
                                                <select size="1" name="tipo">
                                                    <option value="setores" selected>Setores</option>
                                                    <option value="categorias">Categorias</option>
                                                    <option value="aliquotas">Aliquotas</option>
                                                    <option value="locais">Locais</option>
                                                    <option value="medidas">Medidas</option>
                                                </select>
                                            </td>
                                        </tr>
                                    </table>
                                    <br>
                                    <center>
                                        <input type="button" name="bnt" value="  << Voltar   " onclick="goBack();">
                                        <input type="submit" name="bnt" value="Avançar >>">
                                    </center>
                                </td>
                            </form>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <?
    } elseif ($tipo == "setores" && $passo1 && $passo2 && $passo3 && !$passo4) {
        ?>
        <table width="100%" cellspacing="0" cellpadding="10">
            <tr>
                <td>
                    <table width="100%" cellspacing="0" cellpadding="5" border="1" bordercolor="#2A98D3" style="border-collapse: collapse" bgcolor="#FFFFFF">
                        <tr>
                            <td>
                                <br>
                                <center><font size="3"><b>Filtro</b></font></center>
                                <br>
                            </td>
                        </tr>
                        <tr>
                            <form method="POST" action="?sec=relatorios&sub=faturamento" name="filtro">
                                <input type="hidden" name="passo1" value="true">
                                <input type="hidden" name="passo2" value="true">
                                <input type="hidden" name="passo3" value="true">
                                <input type="hidden" name="passo4" value="true">
                                <input type="hidden" name="tipo" value="<?php echo  $tipo ?>">
                                <?
                                //seleciona os operadores
                                $res = mssql_query("SELECT * FROM cx_Gerenciador");

                                $cidab = 0;

                                while ($arr = mssql_fetch_array($res)) {
                                    $idAbertura = "idab" . $arr['idAbertura'];

                                    if ($_POST[$idAbertura] == $arr['idAbertura']) {
                                        echo "<input type='hidden' name='idab" . $arr['idAbertura'] . "' value='" . $arr['idAbertura'] . "'>";

                                        $cidab++;
                                    }
                                }
                                ?>
                                <td>
                                    <br>
                                    <center><font size="2">-- Selecione o(s) setor(es) desejado(s) --</font></center>
                                    <br>
                                    <table align="center" border="0" cellpadding="0" cellspacing="5">
                                        <tr>
                                            <td>
                                                <?
                                                //$sql_setor = "SELECT DISTINCT s.idSetor, s.stSetor FROM prd_Setores s INNER JOIN prd_Produtos p ON s.idSetor = p.idSetor WHERE s.flAtivo = '1' ORDER BY s.stSetor ASC";
                                                $sql_setor = "SELECT * FROM prd_Setores ORDER BY stSetor ASC";
                                                $res = mssql_query($sql_setor);

                                                $count = 4 + $cidab;

                                                while ($arr = mssql_fetch_array($res)) {
                                                    ?>
                                                    <input name="ids<?php echo $arr['idSetor']?>" type="checkbox" value="<?php echo $arr['idSetor']?>" <?php if($arr['flAtivo'] == '1') : ?>  checked="checked" <?php endif; ?> /> <font size="2"><?php echo $arr['stSetor']?> <?php if($arr['flAtivo'] == '0') : ?>(Desativado)<?php endif; ?></font><br />
                                                    <?php
                                                    $count++;
                                                }
                                                ?>
                                            </td>
                                        </tr>
                                    </table>
                                    <br>
                                    <center>
                                        <input type="hidden" name="fd" value="<?php echo  $fd ?>">
                                        <input type="hidden" name="fl" value="<?php echo  $fl ?>">
                                        <input type="button" name="bnt" value="  << Voltar   " onclick="goBack();">
                                        <input type="submit" name="bnt" value="Avançar >>">
                                    </center>
                                </td>
                            </form>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <SCRIPT>
            function selectall(check)
            {
                if (check)
                {
                    <?
                    for ($x = 0; $x <= $count; $x++) {
                    ?>
                    document.forms['filtro']['<?php echo  $x ?>'].checked=true;
                    <?
                    }
                    ?>
                }
                else
                {
                    <?
                    for ($x = 0; $x <= $count; $x++) {
                    ?>
                    document.forms['filtro']['<?php echo  $x ?>'].checked=false;
                    <?
                    }
                    ?>
                }
            }
        </SCRIPT>
        <center><font size="2">
                [ <a href="#" onclick="selectall(true)">Selecionar todos</a> ]
                <br>
                [ <a href="#" onclick="selectall(false)">Limpar todos</a> ]
            </font></center>
        <br>
        <?
    } elseif ($tipo == "categorias" && $passo1 && $passo2 && $passo3 && !$passo4) {
        ?>
        <table width="100%" cellspacing="0" cellpadding="10">
            <tr>
                <td>
                    <table width="100%" cellspacing="0" cellpadding="5" border="1" bordercolor="#2A98D3" style="border-collapse: collapse" bgcolor="#FFFFFF">
                        <tr>
                            <td>
                                <br>
                                <center><font size="3"><b>Filtro</b></font></center>
                                <br>
                            </td>
                        </tr>
                        <tr>
                            <form method="POST" action="?sec=relatorios&sub=faturamento" name="filtro">
                                <input type="hidden" name="passo1" value="true">
                                <input type="hidden" name="passo2" value="true">
                                <input type="hidden" name="passo3" value="true">
                                <input type="hidden" name="passo4" value="true">
                                <input type="hidden" name="tipo" value="<?php echo  $tipo ?>">
                                <?
                                $res = mssql_query("SELECT * FROM cx_Gerenciador");

                                $cidab = 0;

                                while ($arr = mssql_fetch_array($res)) {
                                    $idAbertura = "idab" . $arr['idAbertura'];

                                    if ($_POST[$idAbertura] == $arr['idAbertura']) {
                                        echo "<input type='hidden' name='idab" . $arr['idAbertura'] . "' value='" . $arr['idAbertura'] . "'>";

                                        $cidab++;
                                    }
                                }
                                ?>
                                <td>
                                    <br>
                                    <center><font size="2">-- Selecione a(s) categoria(s) desejada(s) --</font></center>
                                    <br>
                                    <table align="center" border="0" cellpadding="0" cellspacing="5">
                                        <tr>
                                            <td>
                                                <?php
                                                //$sql_cat = "SELECT DISTINCT c.idCategoria, c.stCategoria FROM prd_Categorias c INNER JOIN prd_Produtos p ON c.idCategoria = p.idCategoria WHERE c.flAtivo = '1' ORDER BY c.stCategoria ASC";
                                                $sql_cat = "SELECT * FROM prd_Categorias ORDER BY stCategoria ASC";
                                                $res = mssql_query($sql_cat);

                                                $count = 4 + $cidab;

                                                while ($arr = mssql_fetch_array($res)) {
                                                    ?>
                                                    <input name="idc<?php echo $arr['idCategoria']?>" type="checkbox" value="<?php echo $arr['idCategoria']?>" <?php if($arr['flAtivo'] == '1') : ?> checked="checked" <?php endif; ?> /><font size="2"><?php echo $arr['stCategoria']?> <?php if($arr['flAtivo'] == '0'): ?> (Desativado) <?php endif; ?></font><br />
                                                    <?php
                                                    $count++;
                                                }
                                                ?>
                                            </td>
                                        </tr>
                                    </table>
                                    <br>
                                    <center>
                                        <input type="hidden" name="fd" value="<?php echo  $fd ?>">
                                        <input type="hidden" name="fl" value="<?php echo  $fl ?>">
                                        <input type="button" name="bnt" value="  << Voltar   " onclick="goBack();">
                                        <input type="submit" name="bnt" value="Avançar >>">
                                    </center>
                                </td>
                            </form>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <SCRIPT>
            function selectall(check)
            {
                if (check)
                {
                    <?
                    for ($x = 0; $x <= $count; $x++) {
                    ?>
                    document.forms['filtro']['<?php echo  $x ?>'].checked=true;
                    <?
                    }
                    ?>
                }
                else
                {
                    <?
                    for ($x = 0; $x <= $count; $x++) {
                    ?>
                    document.forms['filtro']['<?php echo  $x ?>'].checked=false;
                    <?
                    }
                    ?>
                }
            }
        </SCRIPT>
        <center><font size="2">
                [ <a href="#" onclick="selectall(true)">Selecionar todos</a> ]
                <br>
                [ <a href="#" onclick="selectall(false)">Limpar todos</a> ]
            </font></center>
        <br>
        <?
    } elseif ($tipo == "aliquotas" && $passo1 && $passo2 && $passo3 && !$passo4) {
        ?>
        <table width="100%" cellspacing="0" cellpadding="10">
            <tr>
                <td>
                    <table width="100%" cellspacing="0" cellpadding="5" border="1" bordercolor="#2A98D3" style="border-collapse: collapse" bgcolor="#FFFFFF">
                        <tr>
                            <td>
                                <br>
                                <center><font size="3"><b>Filtro</b></font></center>
                                <br>
                            </td>
                        </tr>
                        <tr>
                            <form method="POST" action="?sec=relatorios&sub=faturamento" name="filtro">
                                <input type="hidden" name="passo1" value="true">
                                <input type="hidden" name="passo2" value="true">
                                <input type="hidden" name="passo3" value="true">
                                <input type="hidden" name="passo4" value="true">
                                <input type="hidden" name="tipo" value="<?php echo  $tipo ?>">
                                <?
                                $res = mssql_query("SELECT * FROM cx_Gerenciador");

                                $cidab = 0;

                                while ($arr = mssql_fetch_array($res)) {
                                    $idAbertura = "idab" . $arr['idAbertura'];

                                    if ($_POST[$idAbertura] == $arr['idAbertura']) {
                                        echo "<input type='hidden' name='idab" . $arr['idAbertura'] . "' value='" . $arr['idAbertura'] . "'>";

                                        $cidab++;
                                    }
                                }
                                ?>
                                <td>
                                    <br>
                                    <center><font size="2">-- Selecione a(s) aliquota(s) desejada(s) --</font></center>
                                    <br>
                                    <table align="center" border="0" cellpadding="0" cellspacing="5">
                                        <tr>
                                            <td>
                                                <?
                                                $res = mssql_query("SELECT DISTINCT a.idAliquota, a.stAliquota FROM prd_Aliquotas a INNER JOIN prd_Produtos p ON a.idAliquota = p.idAliquota WHERE a.flAtivo = '1' ORDER BY a.stAliquota ASC");

                                                $count = 4 + $cidab;

                                                while ($arr = mssql_fetch_array($res)) {
                                                    echo "<input name=ida" . $arr['idAliquota'] . " type=checkbox value=" . $arr['idAliquota'] . " checked> <font size=2>" . $arr['stAliquota'] . "</font><br>";

                                                    $count++;
                                                }
                                                ?>
                                            </td>
                                        </tr>
                                    </table>
                                    <br>
                                    <center>
                                        <input type="hidden" name="fd" value="<?php echo  $fd ?>">
                                        <input type="hidden" name="fl" value="<?php echo  $fl ?>">
                                        <input type="button" name="bnt" value="  << Voltar   " onclick="goBack();">
                                        <input type="submit" name="bnt" value="Avançar >>">
                                    </center>
                                </td>
                            </form>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <SCRIPT>
            function selectall(check)
            {
                if (check)
                {
                    <?
                    for ($x = 0; $x <= $count; $x++) {
                    ?>
                    document.forms['filtro']['<?php echo  $x ?>'].checked=true;
                    <?
                    }
                    ?>
                }
                else
                {
                    <?
                    for ($x = 0; $x <= $count; $x++) {
                    ?>
                    document.forms['filtro']['<?php echo  $x ?>'].checked=false;
                    <?
                    }
                    ?>
                }
            }
        </SCRIPT>
        <center><font size="2">
                [ <a href="#" onclick="selectall(true)">Selecionar todos</a> ]
                <br>
                [ <a href="#" onclick="selectall(false)">Limpar todos</a> ]
            </font></center>
        <br>
        <?
    } elseif ($tipo == "locais" && $passo1 && $passo2 && $passo3 && !$passo4) {
        ?>
        <table width="100%" cellspacing="0" cellpadding="10">
            <tr>
                <td>
                    <table width="100%" cellspacing="0" cellpadding="5" border="1" bordercolor="#2A98D3" style="border-collapse: collapse" bgcolor="#FFFFFF">
                        <tr>
                            <td>
                                <br>
                                <center><font size="3"><b>Filtro</b></font></center>
                                <br>
                            </td>
                        </tr>
                        <tr>
                            <form method="POST" action="?sec=relatorios&sub=faturamento" name="filtro">
                                <input type="hidden" name="passo1" value="true">
                                <input type="hidden" name="passo2" value="true">
                                <input type="hidden" name="passo3" value="true">
                                <input type="hidden" name="passo4" value="true">
                                <input type="hidden" name="tipo" value="<?php echo  $tipo ?>">
                                <?
                                $res = mssql_query("SELECT * FROM cx_Gerenciador");

                                $cidab = 0;

                                while ($arr = mssql_fetch_array($res)) {
                                    $idAbertura = "idab" . $arr['idAbertura'];

                                    if ($_POST[$idAbertura] == $arr['idAbertura']) {
                                        echo "<input type='hidden' name='idab" . $arr['idAbertura'] . "' value='" . $arr['idAbertura'] . "'>";

                                        $cidab++;
                                    }
                                }
                                ?>
                                <td>
                                    <br>
                                    <center><font size="2">-- Selecione o(s) local(is) desejado(s) --</font></center>
                                    <br>
                                    <table align="center" border="0" cellpadding="0" cellspacing="5">
                                        <tr>
                                            <td>
                                                <?
                                                $res = mssql_query("SELECT DISTINCT l.idLocalizacao, l.stLocalizacao FROM prd_Localizacoes l INNER JOIN prd_Produtos p ON l.idLocalizacao = p.idLocalizacao WHERE l.flAtivo = '1' ORDER BY l.stLocalizacao ASC");

                                                $count = 4 + $cidab;

                                                while ($arr = mssql_fetch_array($res)) {
                                                    echo "<input name=idl" . $arr['idLocalizacao'] . " type=checkbox value=" . $arr['idLocalizacao'] . " checked> <font size=2>" . $arr['stLocalizacao'] . "</font><br>";

                                                    $count++;
                                                }
                                                ?>
                                            </td>
                                        </tr>
                                    </table>
                                    <br>
                                    <center>
                                        <input type="hidden" name="fd" value="<?php echo  $fd ?>">
                                        <input type="hidden" name="fl" value="<?php echo  $fl ?>">
                                        <input type="button" name="bnt" value="  << Voltar   " onclick="goBack();">
                                        <input type="submit" name="bnt" value="Avançar >>">
                                    </center>
                                </td>
                            </form>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <SCRIPT>
            function selectall(check)
            {
                if (check)
                {
                    <?
                    for ($x = 0; $x <= $count; $x++) {
                    ?>
                    document.forms['filtro']['<?php echo  $x ?>'].checked=true;
                    <?
                    }
                    ?>
                }
                else
                {
                    <?
                    for ($x = 0; $x <= $count; $x++) {
                    ?>
                    document.forms['filtro']['<?php echo  $x ?>'].checked=false;
                    <?
                    }
                    ?>
                }
            }
        </SCRIPT>
        <center><font size="2">
                [ <a href="#" onclick="selectall(true)">Selecionar todos</a> ]
                <br>
                [ <a href="#" onclick="selectall(false)">Limpar todos</a> ]
            </font></center>
        <br>
        <?
    } elseif ($tipo == "medidas" && $passo1 && $passo2 && $passo3 && !$passo4) {
        ?>
        <table width="100%" cellspacing="0" cellpadding="10">
            <tr>
                <td>
                    <table width="100%" cellspacing="0" cellpadding="5" border="1" bordercolor="#2A98D3" style="border-collapse: collapse" bgcolor="#FFFFFF">
                        <tr>
                            <td>
                                <br>
                                <center><font size="3"><b>Filtro</b></font></center>
                                <br>
                            </td>
                        </tr>
                        <tr>
                            <form method="POST" action="?sec=relatorios&sub=faturamento" name="filtro">
                                <input type="hidden" name="passo1" value="true">
                                <input type="hidden" name="passo2" value="true">
                                <input type="hidden" name="passo3" value="true">
                                <input type="hidden" name="passo4" value="true">
                                <input type="hidden" name="tipo" value="<?php echo  $tipo ?>">
                                <?
                                $res = mssql_query("SELECT * FROM cx_Gerenciador");

                                $cidab = 0;

                                while ($arr = mssql_fetch_array($res)) {
                                    $idAbertura = "idab" . $arr['idAbertura'];

                                    if ($_POST[$idAbertura] == $arr['idAbertura']) {
                                        echo "<input type='hidden' name='idab" . $arr['idAbertura'] . "' value='" . $arr['idAbertura'] . "'>";

                                        $cidab++;
                                    }
                                }
                                ?>
                                <td>
                                    <br>
                                    <center><font size="2">-- Selecione a(s) medida(s) desejada(s) --</font></center>
                                    <br>
                                    <table align="center" border="0" cellpadding="0" cellspacing="5">
                                        <tr>
                                            <td>
                                                <?
                                                $res = mssql_query("SELECT DISTINCT m.idMedida, m.stMedida FROM prd_Medidas m INNER JOIN prd_Produtos p ON m.idMedida = p.idMedida WHERE m.flAtivo = '1' ORDER BY m.stMedida ASC");

                                                $count = 4 + $cidab;

                                                while ($arr = mssql_fetch_array($res)) {
                                                    echo "<input name=idm" . $arr['idMedida'] . " type=checkbox value=" . $arr['idMedida'] . " checked> <font size=2>" . $arr['stMedida'] . "</font><br>";

                                                    $count++;
                                                }
                                                ?>
                                            </td>
                                        </tr>
                                    </table>
                                    <br>
                                    <center>
                                        <input type="hidden" name="fd" value="<?php echo  $fd ?>">
                                        <input type="hidden" name="fl" value="<?php echo  $fl ?>">
                                        <input type="button" name="bnt" value="  << Voltar   " onclick="goBack();">
                                        <input type="submit" name="bnt" value="Avançar >>">
                                    </center>
                                </td>
                            </form>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <SCRIPT>
            function selectall(check)
            {
                if (check)
                {
                    <?
                    for ($x = 0; $x <= $count; $x++) {
                    ?>
                    document.forms['filtro']['<?php echo  $x ?>'].checked=true;
                    <?
                    }
                    ?>
                }
                else
                {
                    <?
                    for ($x = 0; $x <= $count; $x++) {
                    ?>
                    document.forms['filtro']['<?php echo  $x ?>'].checked=false;
                    <?
                    }
                    ?>
                }
            }
        </SCRIPT>
        <center><font size="2">
                [ <a href="#" onclick="selectall(true)">Selecionar todos</a> ]
                <br>
                [ <a href="#" onclick="selectall(false)">Limpar todos</a> ]
            </font></center>
        <br>
        <?
    } elseif ($passo1 && $passo2 && $passo3 && $passo4 && !$passo5) {
        ?>
        <table width="100%" cellspacing="0" cellpadding="10">
            <tr>
                <td>
                    <table width="100%" cellspacing="0" cellpadding="5" border="1" bordercolor="#2A98D3" style="border-collapse: collapse" bgcolor="#FFFFFF">
                        <tr>
                            <td>
                                <br>
                                <center><font size="3"><b>Filtro</b></font></center>
                                <br>
                            </td>
                        </tr>
                        <tr>
                            <form method="POST" action="?sec=relatorios&sub=faturamento">
                                <input type="hidden" name="passo1" value="true">
                                <input type="hidden" name="passo2" value="true">
                                <input type="hidden" name="passo3" value="true">
                                <input type="hidden" name="passo4" value="true">
                                <input type="hidden" name="passo5" value="true">
                                <input type="hidden" name="fd" value="<?php echo  $fd ?>">
                                <input type="hidden" name="fl" value="<?php echo  $fl ?>">
                                <input type="hidden" name="tipo" value="<?php echo  $tipo ?>">
                                <?
                                $res = mssql_query("SELECT * FROM cx_Gerenciador");

                                while ($arr = mssql_fetch_array($res)) {
                                    $idAbertura = "idab" . $arr['idAbertura'];

                                    if ($_POST[$idAbertura] == $arr['idAbertura']) {
                                        echo "<input type='hidden' name='idab" . $arr['idAbertura'] . "' value='" . $arr['idAbertura'] . "'>";
                                    }
                                }

                                switch ($tipo) {
                                    case $tipo == "setores" :
                                        //$sql_setor = "SELECT * FROM prd_Setores WHERE flAtivo = '1'";
                                        $sql_setor = "SELECT * FROM prd_Setores";
                                        $res = mssql_query($sql_setor);

                                        while ($arr = mssql_fetch_array($res)) {
                                            $idSetor = "ids" . $arr['idSetor'];

                                            if ($_POST[$idSetor] == $arr['idSetor']) {
                                                echo "<input type=hidden name=ids" . $arr['idSetor'] . " value=" . $arr['idSetor'] . ">";
                                            }
                                        }
                                        break;

                                    case $tipo == "categorias" :
                                        //$sql_cat = "SELECT * FROM prd_Categorias WHERE flAtivo = '1'";
                                        $sql_cat = "SELECT * FROM prd_Categorias";
                                        $res = mssql_query($sql_cat);

                                        while ($arr = mssql_fetch_array($res)) {
                                            $idCategoria = "idc" . $arr['idCategoria'];

                                            if ($_POST[$idCategoria] == $arr['idCategoria']) {
                                                echo "<input type=hidden name=idc" . $arr['idCategoria'] . " value=" . $arr['idCategoria'] . ">";
                                            }
                                        }
                                        break;

                                    case $tipo == "aliquotas" :
                                        $res = mssql_query("SELECT * FROM prd_Aliquotas WHERE flAtivo = '1'");

                                        while ($arr = mssql_fetch_array($res)) {
                                            $idAliquota = "ida" . $arr['idAliquota'];

                                            if ($_POST[$idAliquota] == $arr['idAliquota']) {
                                                echo "<input type=hidden name=ida" . $arr['idAliquota'] . " value=" . $arr['idAliquota'] . ">";
                                            }
                                        }
                                        break;

                                    case $tipo == "localizacoes" :
                                        $res = mssql_query("SELECT * FROM prd_Localizacoes WHERE flAtivo = '1'");

                                        while ($arr = mssql_fetch_array($res)) {
                                            $idLocalizacao = "idl" . $arr['idLocalizacao'];

                                            if ($_POST[$idLocalizacao] == $arr['idLocalizacao']) {
                                                echo "<input type=hidden name=idl" . $arr['idLocalizacao'] . " value=" . $arr['idLocalizacao'] . ">";
                                            }
                                        }
                                        break;

                                    case $tipo == "medidas" :
                                        $res = mssql_query("SELECT * FROM prd_Medidas WHERE flAtivo = '1'");

                                        while ($arr = mssql_fetch_array($res)) {
                                            $idMedida = "idm" . $arr['idMedida'];

                                            if ($_POST[$idMedida] == $arr['idMedida']) {
                                                echo "<input type=hidden name=idm" . $arr['idMedida'] . " value=" . $arr['idMedida'] . ">";
                                            }
                                        }
                                        break;
                                }
                                ?>
                                <td>
                                    <br>
                                    <center><font size="2">-- Digite o nome do produto desejado, ou deixe em branco caso queira TODOS --</font></center>
                                    <br>
                                    <table align="center" border="0" cellpadding="0" cellspacing="5">
                                        <tr>
                                            <td><font size="2"><b>Produto:</b></font></td>
                                            <td>
                                                <input type="text" size="20" name="produto" id="produto" style="border: 1px solid #2A98D3;">
                                                <input type="button" name="button" value=" ? " onclick="NewWindow('relatorios/selectNomeProduto.php','selectProduto','400','300','yes','center');">
                                            </td>
                                        </tr>
                                    </table>
                                    <br>
                                    <center>
                                        <input type="button" name="bnt" value="         << Voltar          " onclick="goBack();">
                                        <input type="submit" name="bnt" value="Gerar Relatório >>">
                                    </center>
                                </td>
                            </form>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <?
    } else {
        ?>
        <div id="corporelatorio">
            <table width="100%" cellspacing="0" cellpadding="10">
                <tr>
                    <td>
                        <table width="100%" cellspacing="0" cellpadding="5" border="1" bordercolor="#2A98D3" style="border-collapse: collapse" bgcolor="#FFFFFF">
                            <tr>
                                <td>
                                    <br>
                                    <center><font size="3"><b>Relatório de Faturamento</b></font></center>
                                    <br>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <br>

                                    <br>
                                    <div align="center">
                                        <table>
                                            <tr>
                                                <?
                                                $res = mssql_query("SELECT * FROM op_Operadores WHERE idOperador = " . $_COOKIE['idOperador']);
                                                $arr = mssql_fetch_array($res);

                                                echo "<tr><td align=center><font size=2>Relatório emitido por <b>" . $arr['stApelido'] . "</b> [" . $arr['idOperador'] . "] em " . date("d/m/Y") . " As " . date("H:i") . " H.</font></td></tr>";
                                                echo "<tr><td align=center><font size=2>&lt;Referênte ao período de " . date("d/m/Y", strtotime($fd)) . " até " . date("d/m/Y", strtotime($fl)) . "&gt;</font></td></tr>";
                                                ?>
                                            </tr>
                                        </table>
                                    </div>
                                    <br>
                                    <table width="100%" border="1" bordercolor="#FFFFFF" style="border-collapse: collapse" bgcolor="#FFFFFF"  cellspacing="0" cellpadding="3">
                                        <tr bgcolor="#2A98D3">
                                            <td width="10%"><font size="2" face="arial" color="#FFFFFF"><b><nobr>Código</nobr></b></font></td>
                                            <td width="25%"><font size="2" face="arial" color="#FFFFFF"><b><nobr>Produto</nobr></b></font></td>
                                            <td width="5%" align="right"><font size="2" face="arial" color="#FFFFFF"><b><nobr>Custo Unit</nobr></b></font></td>
                                            <td width="10%" align="right"><font size="2" face="arial" color="#FFFFFF"><b><nobr>Quantidade</nobr></b></font></td>
                                            <td width="10%" align="right"><font size="2" face="arial" color="#FFFFFF"><b><nobr>Custo Total</nobr></b></font></td>
                                            <td width="10%" align="right"><font size="2" face="arial" color="#FFFFFF"><b><nobr>Valor Total</nobr></b></font></td>
                                            <td width="10%" align="right"><font size="2" face="arial" color="#FFFFFF"><b><nobr>Lucro Total</nobr></b></font></td>
                                            <td width="10%" align="right"><font size="2" face="arial" color="#FFFFFF"><b><nobr>Lucro Total (%)</nobr></b></font></td>
                                        </tr>
                                        <?
                                        $res = mssql_query("SELECT * FROM cx_Gerenciador");
                                        $abertura = "g.idAbertura IN(";
                                        while ($arr = mssql_fetch_array($res)) {
                                            $idAbertura = "idab" . $arr['idAbertura'];

                                            if ($_POST[$idAbertura] == $arr['idAbertura']) {
                                                $abertura .= $arr['idAbertura'].",";
                                            }
                                        }
                                        $abertura = substr($abertura, 0, (strlen($abertura) - 1)).")";

                                        switch ($tipo) {
                                            case $tipo == "setores" :
                                                //$sql_setor = "SELECT * FROM prd_Setores WHERE flAtivo = '1'";
                                                $sql_setor = "SELECT * FROM prd_Setores";
                                                $res = mssql_query($sql_setor);
                                                $setores = "";
                                                $x = true;
                                                while ($arr = mssql_fetch_array($res)) {
                                                    $idSetor = "ids" . $arr['idSetor'];

                                                    if ($_POST[$idSetor] == $arr['idSetor']) {
                                                        if ($x == true) {
                                                            $setores .= "p.idSetor = " . $arr['idSetor'];
                                                            $x = false;
                                                        } else {
                                                            $setores .= " OR p.idSetor = " . $arr['idSetor'];
                                                        }
                                                    }
                                                }
                                                break;

                                            case $tipo == "categorias" :
                                                //$sql_cat = "SELECT * FROM prd_Categorias WHERE flAtivo = '1'";
                                                $sql_cat = "SELECT * FROM prd_Categorias";
                                                $res = mssql_query($sql_cat);
                                                $categorias = "";
                                                $x = true;
                                                while ($arr = mssql_fetch_array($res)) {
                                                    $idCategoria = "idc" . $arr['idCategoria'];

                                                    if ($_POST[$idCategoria] == $arr['idCategoria']) {
                                                        if ($x == true) {
                                                            $categorias .= "p.idCategoria = " . $arr['idCategoria'];
                                                            $x = false;
                                                        } else {
                                                            $categorias .= " OR p.idCategoria = " . $arr['idCategoria'];
                                                        }
                                                    }
                                                }
                                                break;

                                            case $tipo == "aliquotas" :
                                                $res = mssql_query("SELECT * FROM prd_Aliquotas WHERE flAtivo = '1'");
                                                $aliquotas = "";
                                                $x = true;
                                                while ($arr = mssql_fetch_array($res)) {
                                                    $idAliquota = "ida" . $arr['idAliquota'];

                                                    if ($_POST[$idAliquota] == $arr['idAliquota']) {
                                                        if ($x == true) {
                                                            $aliquotas .= "p.idAliquota = " . $arr['idAliquota'];
                                                            $x = false;
                                                        } else {
                                                            $aliquotas .= " OR p.idAliquota = " . $arr['idAliquota'];
                                                        }
                                                    }
                                                }
                                                break;

                                            case $tipo == "localizacoes" :
                                                $res = mssql_query("SELECT * FROM prd_Localizacoes WHERE flAtivo = '1'");
                                                $localizacoes = "";
                                                $x = true;
                                                while ($arr = mssql_fetch_array($res)) {
                                                    $idLocalizacao = "idl" . $arr['idLocalizacao'];

                                                    if ($_POST[$idLocalizacao] == $arr['idLocalizacao']) {
                                                        if ($x == true) {
                                                            $localizacoes .= "p.idLocalizacao = " . $arr['idLocalizacao'];
                                                            $x = false;
                                                        } else {
                                                            $localizacoes .= " OR p.idLocalizacao = " . $arr['idLocalizacao'];
                                                        }
                                                    }
                                                }
                                                break;

                                            case $tipo == "medidas" :
                                                $res = mssql_query("SELECT * FROM prd_Medidas WHERE flAtivo = '1'");
                                                $medidas = "";
                                                $x = true;
                                                while ($arr = mssql_fetch_array($res)) {
                                                    $idMedida = "idm" . $arr['idMedida'];

                                                    if ($_POST[$idMedida] == $arr['idMedida']) {
                                                        if ($x == true) {
                                                            $medidas .= "p.idMedida = " . $arr['idMedida'];
                                                            $x = false;
                                                        } else {
                                                            $medidas .= " OR p.idMedida = " . $arr['idMedida'];
                                                        }
                                                    }
                                                }
                                                break;
                                        }

                                        if ($produto) {
                                            $produto = "AND p.stProduto like '%" . $produto . "%'";
                                        }
                                        //Consulta para trazer o resultado do relatorio

                                        $sql = "SELECT m.stMedida, m.flFracionado, i.idCodProduto, i.idProduto, p.stProduto, i.vrCusto, SUM(i.nrQuantidade) as nrQuantidade, SUM(i.vrTotal) as vrTotal
                                                FROM (SELECT * FROM cx_Itens UNION SELECT * FROM cx_Itens_Temp) i
                                                INNER JOIN prd_Produtos p
                                                ON i.idProduto = p.idProduto
                                                INNER JOIN prd_Medidas m
                                                ON p.idMedida = m.idMedida
                                                INNER JOIN cx_Gerenciador g
                                                ON i.idAbertura = g.idAbertura
                                                WHERE ($abertura) AND i.flAtivo = 1 AND i.dtData BETWEEN '".$fd."' AND '".$fl."' " .

                                            ($tipo == "setores" ? " AND ($setores) " : "") .
                                            ($tipo == "categorias" ? " AND ($categorias) " : "") .
                                            ($tipo == "aliquotas" ? " AND ($aliquotas) " : "") .
                                            ($tipo == "localizacoes" ? " AND ($localizacoes) " : "") .
                                            ($tipo == "medidas" ? " AND ($medidas) " : "") . " $produto
                                            AND i.flAtivo = '1'
                                            GROUP BY i.idCodProduto, i.idProduto, p.stProduto, m.stMedida, m.flFracionado, i.vrCusto ORDER BY nrQuantidade DESC";

                                        $res = @mssql_query($sql);

                                        $cnt = 0;
                                        $somaLucrod = 0;
                                        $somaLucrop = 0;
                                        $somaCusto = 0;
                                        $somaDesconto = 0;
                                        $somaVrTotal = 0;
                                        while ($arr = @mssql_fetch_array($res)) {
                                            if ($arr['flFracionado'])
                                            {
                                                if ($arr['nrQuantidade'] > 0)
                                                    $nrQuantidade = number_format(($arr['nrQuantidade'] / 1000), 3, ".", "");
                                            }
                                            else
                                            {
                                                $nrQuantidade = intval($arr['nrQuantidade']);
                                            }

                                            $vrTotal = $arr['vrTotal'];
                                            $custo_ttl = ($arr['vrCusto'] * $nrQuantidade);
                                            $lucrod = ($vrTotal - $custo_ttl);
                                            if ($custo_ttl == 0) {
                                                $lucrop = ($arr['vrCusto'] == 0 ? 100 : ((100 * $vrTotal ) / 1) - 100);
                                            }else{
                                                $lucrop = ($arr['vrCusto'] == 0 ? 100 : ((100 * $vrTotal ) / $custo_ttl) - 100);
                                            }

                                            ?>
                                            <tr bgcolor="<?php echo (($c++ & 1) ? "#FFFFFF" : "#F0F0F0")?>">
                                                <td><font size="2"><nobr><?php echo  $arr['idCodProduto'] ?></nobr></font></td>
                                                <td><font size="2"><?php echo  $arr['stProduto'] ?></font></td>
                                                <td align="right"><font size="2"><nobr>R$ <?php echo  number_format($arr['vrCusto'], 2, ",", ".") ?></nobr></font></td>
                                                <td align="right"><font size="2"><nobr><?php echo $nrQuantidade?> <?php echo $arr['stMedida']?></nobr></font></td>
                                                <td align="right"><font size="2"><nobr>R$ <?php echo number_format($custo_ttl, 2, ",", ".") ?></nobr></font></td>
                                                <td align="right"><font size="2"><nobr>R$ <?php echo number_format($vrTotal, 2, ",", ".") ?></nobr></font></td>
                                                <td align="right"><font size="2"><nobr>R$ <?php echo number_format($lucrod, 2, ",", ".") ?></nobr></font></td>
                                                <td align="right"><font size="2"><nobr><?php echo number_format($lucrop, 2, ",", ".") ?> %</nobr></font></td>
                                            </tr>
                                            <?

                                            $cnt++;
                                            $somaCusto += $custo_ttl;
                                            $somaVrTotal += $vrTotal;
                                            $somaLucrod += $lucrod;
                                            $somaLucrop += $lucrop;
                                        }

                                        $totalCancelamento = getCancelamentos($abertura, $fd, $fl);
                                        $somaAcrescimo = getAcrescimo($abertura, $fd, $fl);
                                        $somaDesconto = getDesconto($abertura, $fd, $fl);

//                                        $arr = mssql_fetch_array(mssql_query("
//                                                    select sum(v.vrTotal) as vrTotal from (select vrTotal, vrDesconto,vrAcrescimo, idAbertura, dtData, flAtivo from cx_Vendas_Temp UNION select vrTotal, vrDesconto,vrAcrescimo, idAbertura, dtData, flAtivo from cx_Vendas) v
//                                                        inner join cx_Gerenciador g on g.idAbertura = v.idAbertura WHERE ($abertura) AND v.flAtivo = '1' AND v.dtData BETWEEN '".$fd."' AND '".$fl."' "));
//                                        $somaVrTotal = $arr['vrTotal'];


                                        $aberturaSemGerenciador = str_replace("g.", "", $abertura);
                                        $sqlTotal = "select COALESCE(SUM(vrTotal), 0) as vrTotal, COALESCE(SUM(vrDesconto), 0) as vrDesconto, COALESCE(SUM(vrAcrescimo), 0) as vrAcrescimo from (
                                            (
                                                select COALESCE(SUM(vrTotal), 0) as vrTotal, COALESCE(SUM(vrDesconto), 0) as vrDesconto, COALESCE(SUM(vrAcrescimo), 0) as vrAcrescimo from cx_Vendas_Temp VT
                                                where ($aberturaSemGerenciador) AND VT.dtData between '".$fd."' AND '".$fl."' AND VT.flAtivo = 1
                                            )
                                            UNION
                                            (
                                                select COALESCE(SUM(vrTotal), 0) as vrTotal, COALESCE(SUM(vrDesconto), 0) as vrDesconto, COALESCE(SUM(vrAcrescimo), 0) as vrAcrescimo from cx_Vendas VV
                                                where ($aberturaSemGerenciador) AND VV.dtData between '".$fd."' AND '".$fl."' AND VV.flAtivo = 1
                                            )
                                            ) V";
                                        $arr = mssql_fetch_array(mssql_query($sqlTotal));
                                        $somaVrTotalGeral = $arr['vrTotal'];
                                        $somaVrDescontoGeral = $arr['vrDesconto'];
                                        $somaVrAcrescimoGeral = $arr['vrAcrescimo'];


                                        $contaAssinada = getTotalPendura($abertura);


                                        $sumTotal = $somaVrTotal - $somaVrDescontoGeral + $somaVrAcrescimoGeral;
                                        $sumLucro = $somaVrTotal - $somaCusto;
                                        $sumLucroGeral = $sumTotal - $somaCusto;

                                        ?>
                                        <tr bgcolor="#E2F0F9" class="teste">
                                            <td colspan="4"><font size="2" face="arial"><b>Valor Total R$:</b></font></td>
                                            <td align="right"><font size="2" face="arial"><b><nobr>R$ <?php echo number_format($somaCusto, 2, ",", ".")?></nobr></b></font></td>
                                            <td align="right"><font size="2" face="arial"><b><nobr>R$ <?php echo number_format($somaVrTotal, 2, ",", ".")?></nobr></b></font></td>
                                            <td align="right"><font size="2" face="arial"><b><nobr>R$ <?php echo number_format($sumLucro, 2, ",", ".")?></b></font></td>
                                            <td align="right"><font size="2" face="arial"><b><nobr><?php echo @number_format(($sumLucro/$somaVrTotal) * 100, 2, ",", ".") ?> %</nobr></b></font></td>
                                        </tr>
                                        <tr>
                                            <td colspan="5"><font size="2" face="arial"><b>Valor Total em Desconto R$:</b></font></td>
                                            <td align="right"><font size="2" face="arial"><b><nobr>(-) R$ <?php echo number_format($somaVrDescontoGeral, 2, ",", ".")?></nobr></b></font></td>
                                            <td align="right"><font size="2" face="arial"><b><nobr>(-) R$ <?php echo number_format($somaVrDescontoGeral, 2, ",", ".")?></nobr></b></font></td>
                                            <td></td>
                                        </tr>
                                        <tr>
                                            <td colspan="5"><font size="2" face="arial"><b>Acréscimo R$:</b></font></td>
                                            <td align="right"><font size="2" face="arial"><b><nobr>(+) R$ <?php echo number_format($somaVrAcrescimoGeral, 2, ",", ".")?></nobr></b></font></td>
                                            <td align="right"><font size="2" face="arial"><b><nobr>(+) R$ <?php echo number_format($somaVrAcrescimoGeral, 2, ",", ".")?></nobr></b></font></td>
                                            <td></td>
                                        </tr>
                                        <tr bgcolor="#cccccc">
                                            <td colspan="4"><font size="2" face="arial"><b>Valor Total Geral R$:</b></font></td>
                                            <td align="right"><font size="2" face="arial"><b><nobr>R$ <?php echo number_format($somaCusto, 2, ",", ".")?></nobr></b></font></td>
                                            <td align="right"><font size="2" face="arial"><b><nobr>R$ <?php echo number_format($sumTotal, 2, ",", ".")?></nobr></b></font></td>
                                            <td align="right"><font size="2" face="arial"><b><nobr>R$ <?php echo number_format($sumLucroGeral, 2, ",", ".")?></b></font></td>
                                            <td colspan="2"></td>
                                        </tr>
                                        <tr bgcolor="#E2F0F9">
                                            <td colspan="7"><font size="2" face="arial"><b>Média Margem Lucro:</b></font></td>
                                            <td align="right"><font size="2" face="arial"><b><nobr><?php echo  @number_format(($sumLucroGeral/$somaVrTotalGeral) * 100, 2, ",", ".") ?> %</nobr></b></font></td>
                                        </tr>
                                        <tr bgcolor="#E2F0F9">
                                            <td colspan="7"><font size="2" face="arial"><b>Margem Contribuição:</b></font></td>
                                            <td align="right"><font size="2" face="arial"><b><nobr><?php echo  @number_format($sumTotal / $somaCusto, 2, ",", ".") ?> %</nobr></b></font></td>
                                        </tr>
                                        <tr bgcolor="#E2F0F9">
                                            <td colspan="7"><font size="2" face="arial"><b>Cancelamentos:</b></font></td>
                                            <td align="right"><font size="2" face="arial"><b><nobr>R$ <?php echo  @number_format($totalCancelamento, 2, ",", ".") ?></nobr></b></font></td>
                                        </tr>
                                        <tr bgcolor="#E2F0F9">
                                            <td colspan="7"><font size="2" face="arial"><b>Conta Assinada:</b></font></td>
                                            <td align="right"><font size="2" face="arial"><b><nobr>R$ <?php echo  @number_format($contaAssinada, 2, ",", ".") ?></nobr></b></font></td>
                                        </tr>
                                    </table>
                                    <br>

                                    <br>
                                </td>

                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </div>

        <p align="center"><input type="button" name="button" value="Vers&atilde;o para impress&atilde;o" onclick="NewWindow('relatorios/versaoImpressao.php','versaoImpressao','full','full','yes','center'); return false;" /></p>

        <?
    }
}
?>
