<?php

namespace App\Entities;

use Database\Factories\UserFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;
use Prettus\Repository\Traits\TransformableTrait;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class User extends Authenticatable implements JWTSubject
{
    use HasApiTokens;
    use Notifiable;
    use TransformableTrait;
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $table = 'op_Operadores';
    protected $primaryKey = 'idOperador';
    public $incrementing = false;
    public $timestamps = false;
    protected $dateFormat = 'd/m/Y';

    protected $fillable = [
        'idOperador',
        'idPerfil',
        'stApelido',
        'stNome',
        'stSenha',
        'nrAcessos',
        'stEmail',
        'stTelefone1',
        'stTelefone2',
        'stRg',
        'stEndereco',
        'stCargo',
        'stCartao',
        'nrPontos',
        'dtAdmissao',
        'dtUltimoacesso',
        'dtAlteracao',
        'flAtivo',
        'stOBS'
    ];
    protected $hidden = [
        'remember_token',
        'password',
        'idOperadorIntegracao',
        'stIdentFid',
        'stIdentFid',
        'sync',
        'binDigital',
        'stCartao',
    ];

    protected $appends = [
        'password',
        'active'
    ];

    protected $casts = [
        'flAtivo' => 'boolean',
        'idOperador' =>'integer',
        'idPerfil'=>'integer',
        'nrAcessos'=>'integer',

    ];

    protected $maps = [
        'active' => 'flAtivo'
    ];

        /**
     * Create a new factory instance for the model.
     *
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    protected static function newFactory()
    {
        return UserFactory::new();
    }

//    public function getDtAlteracaoAttribute(){
//        return Carbon::parse($this->dtAlteracao)->format('d/m/Y');
//    }
//
//    public function gettAdmissaoAttribute(){
//        return Carbon::parse($this->dtAdmissao)->format('d/m/Y');
//    }

    public function getPasswordAttribute()
    {
        return $this->stSenha;
    }

    public function getActiveAttribute()
    {
        return $this->flAtivo;
    }

    public function perfil()
    {
        return $this->belongsTo(Profile::class, 'idPerfil');
    }

    public function getAuthPassword()
    {
        return $this->stSenha;
    }

    public function hasAcesso($permission)
    {
        $permissions = json_decode($this->perfil->stIds);
        return in_array($permission, $permissions);
    }

    public function access_rules()
    {
        $permissions = array_flatten(json_decode($this->perfil->stIds));

        return [
            "nati" => in_array(8, $permissions),            //  Acesso ao Nati
            "products" => in_array(7, $permissions),        //  Acesso ao módulo Produtos
            "users" => in_array(19, $permissions),          //  Acesso ao módulo Operadores
            "clients" => in_array(20, $permissions),        //  Acesso ao módulo Clientes
            "printer" => in_array(26, $permissions),        //  Acesso ao módulo Impressora
            "suppliers" => in_array(29, $permissions),      //  Acesso ao módulo Fornecedores
            "president" => in_array(33, $permissions),      //  Acesso ao módulo Presidente
            "stock" => in_array(46, $permissions),          //  Acesso ao módulo Estoque
            "expenses" => in_array(50, $permissions),       //  Acesso ao módulo Finanças
            "payments" => in_array(52, $permissions),       //  Acesso ao módulo Formas de Pagamento
            "reports" => in_array(55, $permissions),        //  Acesso ao módulo Relatórios
            "employees" => in_array(84, $permissions),      //  Acesso ao módulo Funcionários
            "review" => in_array(120, $permissions),        //  Acesso ao painel de revisão Fiscal
        ];
    }

    public function rules()
    {
        $permissions = array_flatten(json_decode($this->perfil->stIds));

        $rules = [];

        if (in_array(23, $permissions)) { /* Verifica a permissao de administrar usuarios*/
            $users = [
                "can_create" => true,
                "can_update" => true,
                "can_delete" => true
            ];
        } else {
            $users = [
                "can_create" => false,
                "can_update" => false,
                "can_delete" => false
            ];
        }

        $rules['users'] = $users;

        /*Permissoes para administrar produtos*/
        $products = [
            "can_create" => in_array(10, $permissions),
            "can_update" => in_array(10, $permissions),
            "can_delete" => in_array(25, $permissions),
        ];

        $rules['products'] = $products;

        if (in_array(30, $permissions)) { /* Verifica a permissao de administrar Fornecedores */
            $suppliers = [
                "can_create" => true,
                "can_update" => true,
                "can_delete" => true
            ];
        } else {
            $suppliers = [
                "can_create" => false,
                "can_update" => false,
                "can_delete" => false
            ];
        }
        $rules['suppliers'] = $suppliers;

        if (in_array(22, $permissions)) { /* Verifica a permissao de administrar Clientes */
            $customers = [
                "can_create" => true,
                "can_update" => true,
                "can_delete" => true
            ];
        } else {
            $customers = [
                "can_create" => false,
                "can_update" => false,
                "can_delete" => false
            ];
        }

        $rules['customers'] = $customers;

        if (in_array(53, $permissions)) {
            $payments = [
                "can_create" => true,
                "can_update" => true,
                "can_delete" => true
            ];
        } else {
            $payments = [
                "can_create" => false,
                "can_update" => false,
                "can_delete" => false
            ];
        }
        $rules['payments'] = $payments;

        if(in_array(33, $permissions)){
            $president = [
                "can_create" => true,
                "can_update" => true,
                "can_delete" => false
            ];
            if(in_array(113, $permissions)){
                $president['can_delete'] = true;
            }
        } else {
            $president = [
                "can_create" => false,
                "can_update" => false,
                "can_delete" => false
            ];
        }
        $rules['president'] = $president;
        return $rules;
    }

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [
            'name' => $this->stApelido,
            'rules' => $this->rules()
        ];
    }
}
