<?php

namespace App\Http\Controllers;

use App\Services\Nati\DashboardService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    protected $service;

    /**
     * @var DashboardService
     */
    public function __construct(DashboardService $service)
    {
        $this->service = $service;
        //$this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user = Auth::user();
//        return view('nati.dashboard');
    }

    public function getSalesByMonth()
    {
        $res  = $this->service->getSalesByMonth();
        return $res;
    }

    public function getTopProducts(Request $request)
    {
        return $this->service->getTopProducts($request);
    }

    public function getStatisticsByMonth(Request $request)
    {
        try {
            return $this->service->getStatisticsByMonth($request);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }

    }

    public function getSalesComparative(Request $request)
    {
        try {
            return $this->service->getSalesComparative($request);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }

    public function getSalesBySegment(Request $request)
    {
        try {
            return $this->service->getSalesBySegment($request);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }

    public function getCancelledSales(Request $request)
    {
        try {
            return $this->service->getCancelledSales($request);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }

    public function getSalesByDay(Request $request)
    {
        try {
            return $this->service->getSalesByDay($request);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }
    public function getSalesByTime(Request $request)
    {
        try {
            return $this->service->getSalesByTime($request);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }
}
