<?php

namespace App\Observers;

use App\Entities\Master;
use Illuminate\Support\Facades\Cache;

class MasterObserver
{
    /**
     * Handle the master "created" event.
     *
     * @param Master $master
     * @return void
     */
    public function created(Master $master)
    {
        Cache::forget('master');
    }

    /**
     * Handle the master "updated" event.
     *
     * @param Master $master
     * @return void
     */
    public function updated(Master $master)
    {
        Cache::forget('master');
    }

    /**
     * Handle the master "deleted" event.
     *
     * @param Master $master
     * @return void
     */
    public function deleted(Master $master)
    {
        Cache::forget('master');
    }

    /**
     * Handle the master "restored" event.
     *
     * @param Master $master
     * @return void
     */
    public function restored(Master $master)
    {
        Cache::forget('master');
    }

    /**
     * Handle the master "force deleted" event.
     *
     * @param Master $master
     * @return void
     */
    public function forceDeleted(Master $master)
    {
        Cache::forget('master');
    }
}
