<?php
/**
 * Created by PhpStorm.
 * User: clecio
 * Date: 14/06/2017
 * Time: 10:29
 */
namespace App\Services;

use App\Repositories\CentroDeCustoRepository;
use App\Validators\CentroDeCustoValidator;
use Carbon\Carbon;
use Prettus\Validator\Contracts\ValidatorInterface;

class CentroDeCustoService {

    private $repository;
    private $validator;

    public function __construct(CentroDeCustoRepository $repository, CentroDeCustoValidator $validator) {
        $this->repository = $repository;
        $this->validator = $validator;
        $this->repository->pushCriteria(app('Prettus\Repository\Criteria\RequestCriteria'));
    }

    public function get() {

        return $this->repository->all();
    }

    public function getById($id) {

        return $this->repository->find($id);
    }

    public function insert($data) {

        if ($this->repository->all()->last()){
            $idCentroCusto = $this->repository->all()->last()->idCentroCusto;
        }else{
            $idCentroCusto = 0;
        }

        $data = [
            'idCentroCusto' => $idCentroCusto + 1,
            'stCentroCusto' => $data['stCentroCusto'],
            'dtAlteracao' => Carbon::now()
        ];
        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_CREATE);
        return $this->repository->create($data);
    }

    public function update($data, $id) {

        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_UPDATE);
        return $this->repository->update($data, $id);
    }

    public function delete($id) {

        return $this->repository->delete($id);
    }

}
