<?php

namespace App\Services;


use App\Repositories\ItemTempRepository;
use App\Validators\ItemValidator;

class ItemsService
{
    protected $repository;
    protected $validator;


    public function __construct(ItemTempRepository $repository, ItemValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function getDetails($id, $id_open)
    {
        return $this->repository->findWhere(['idVenda' => $id, 'idAbertura' => $id_open]);
    }

    public function getItens($id_open)
    {
        return $this->repository->findWhere(['id_open' => $id_open, 'active' => true]);
    }
}
