<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDlvClientesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('dlv_Clientes')) {
            Schema::create('dlv_Clientes', function (Blueprint $table) {
                $table->bigInteger('idCliente', false, true);
                $table->boolean('flPessoaJuridica');
                $table->string('stCliente', 60);
//                $table->string('stNomeFantasia', 50)->nullable();

//                  [stSocios] [nvarchar](100) NULL,
//                  [stContato] [nvarchar](50) NULL,
//                  [stCPF_CNPJ] [nvarchar](18) NULL,
//                  [stRG_IE] [nvarchar](15) NULL,
//                  [nrNumero] [nvarchar](9) NOT NULL,
//                  [stComplemento] [nvarchar](50) NULL,
//                  [idCEP] [bigint] NOT NULL,
//                  [stEmail] [nvarchar](50) NULL,
//                  [stSite] [nvarchar](50) NULL,
//                  [flBloqueado] [bit] NOT NULL,
//                  [stBanco] [nvarchar](20) NULL,
//                  [stAgencia] [nvarchar](7) NULL,
//                  [stConta] [nvarchar](15) NULL,
//                  [stContatoBanco] [nvarchar](50) NULL,
//                  [stTelefoneBanco] [nvarchar](20) NULL,
//                  [stOBS] [text] NULL,
//                  [flAtivo] [bit] NOT NULL,
//                  [stVencimentosFatura] [nvarchar](11) NOT NULL CONSTRAINT [DF_dlv_Clientes_stVencimentosFatura]  DEFAULT ((1)),
//                  [dtCadastro] [smalldatetime] NOT NULL,
//                  [stOperador] [nvarchar](20) NOT NULL,
//                  [vrSaldo] [decimal](9, 2) NOT NULL CONSTRAINT [DF_dlv_Clientes_vrSaldo]  DEFAULT ((0)),
//                  [vrLimite] [decimal](9, 2) NOT NULL CONSTRAINT [DF_dlv_Clientes_vrLimite]  DEFAULT ((0)),
//                  [stSenha] [nvarchar](32) NULL,
//                  [flContaAssinada] [bit] NOT NULL CONSTRAINT [DF_dlv_Clientes_flContaAssinada]  DEFAULT ((0)),
//                  [dtUltimaCompra] [smalldatetime] NULL,
//                  [dtUltimaAlteracao] [smalldatetime] NOT NULL,
//                  [stOperadorUltimaAlteracao] [nvarchar](20) NOT NULL,
//                  [stSexo] [nvarchar](1) NOT NULL CONSTRAINT [DF_dlv_Clientes_stSexo]  DEFAULT (N\'I\'),
//                  [flFuncionario] [bit] NOT NULL CONSTRAINT [DF_dlv_Clientes_flFuncionario]  DEFAULT ((0)),
//                  [idCategoriaFuncionario] [smallint] NULL,
//                  [dtUltimoDeposito] [datetime] NULL,
//                  [stTrilha2] [nvarchar](20) NULL,
//                  [idEmpresa] [smallint] NULL,
//                  [stMatricula] [nvarchar](20) NULL,
//                  [stFilial] [nvarchar](20) NULL,
//                  [idMotivoBloqueio] [smallint] NOT NULL CONSTRAINT [DF_dlv_Clientes_idMotivoBloqueio]  DEFAULT ((0)),
//                  [vrEntrega] [decimal](9, 2) NOT NULL CONSTRAINT [DF_dlv_Clientes_vrEntrega]  DEFAULT ((0)),
//                  [binDigital] [image] NULL,
//                  [vrDescontoVenda] [decimal](9, 2) NOT NULL CONSTRAINT [DF_dlv_Clientes_vrDescontoVenda]  DEFAULT ((0)),
//                  [stOBSPrint] [text] NULL CONSTRAINT [DF_dlv_Clientes_stOBSPrint]  DEFAULT (\'SEM OBSERVACAO\'),
//                  [stCEP] [nvarchar](8) NULL,
//                  [vrSaldoPagamento] [decimal](9, 2) NOT NULL CONSTRAINT [DF_dlv_Clientes_vrSaldoPagamento]  DEFAULT ((0)),
//                  [stDigital] [text] NULL,
//                  [dtAlteracao] [datetime] NOT NULL CONSTRAINT [DF_dlv_Clientes_dtAlteracao]  DEFAULT (getdate()),
//                  [nrTipoTerceiro] [int] NOT NULL CONSTRAINT [DF_dlv_Clientes_nrTipoTerceiro]  DEFAULT ((1)),
//                  [stOBSDelivery] [text] NULL,
//                  [idClienteIntegracao] [int] NULL,
//                  [stEmailGerente] [nvarchar](50) NULL,
//                  [dtNascimento] [datetime] NULL,
//                  [stEmpresa] [nvarchar](50) NULL,
//                  [idEmpresaContaAssinada] [int] NULL,

                $table->primary('idCliente');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dlv_Clientes');
    }
}
