<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEmitenteTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('Emitente')) {
            Schema::create('Emitente', function (Blueprint $table) {
                $table->increments('idEmitente');
                $table->boolean('flAtivo');
                $table->string('NomeFantasia', 60);
                $table->string('NomeFantasia1', 100);
                $table->string('Cnpj', 14);
                $table->string('Cpf', 11);
                $table->string('Logradouro', 60);
                $table->string('Nro', 60);
                $table->string('Complemento', 60);
                $table->string('Bairro', 60);
                $table->string('Cidade', 60);
                $table->integer('CodigoMunicipio');
                $table->string('Pais', 60);
                $table->integer('CodigoPais');
                $table->string('Uf', 2);
                $table->string('Telefone', 14);
                $table->string('Ie', 14);
                $table->string('Iest', 14);
                $table->string('Im', 15);
                $table->string('Cnae', 7);
                $table->integer('Crt');
                $table->string('Cep', 8);
                $table->integer('NrNfce');
                $table->string('Csc', 36);
                $table->string('CidCsc', 100);
                $table->dateTime('dtAlteracao');

            });
        }
    }

/**
 * Reverse the migrations.
 *
 * @return void
 */
public
function down()
{
    Schema::dropIfExists('Emitente');
}
}
