<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterMobyoConfigTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::dropIfExists('mobyo_payments');
        Schema::dropIfExists('mobyo_config');

        Schema::create('mobyo_config', function (Blueprint $table) {
            $table->id();
            $table->string('engine', 50)->nullable();
            $table->string('idMerchant', 50)->nullable();
            $table->boolean('flClienteFixo')->default(true);
            $table->integer('idCliente')->nullable();
            $table->string('codProdutoGenerico')->nullable();
            $table->integer('idCaixa')->default(16);
            $table->integer('idUser')->default(99);
            $table->boolean('flFormaPagamentoFixa')->default(true);
            $table->integer('idFormaPagamentoFixa')->default(1);
            $table->string('idDeliveryPadrao')->default('127.0.0.1');
            $table->boolean('flSalvarClienteObservacao')->default(true);
            $table->boolean('flSalvarTaxaEntrega')->default(false);
            $table->boolean('flEmitirCupomDelivery')->default(true);
            $table->boolean('flEmitirCupomRemoto')->default(true);
            $table->boolean('flUsarPainelPreparo')->default(false);
            $table->boolean('flSalvarVendaAutomaticamente')->default(false);
            $table->boolean('flDespacharPedidoAutomaticamente')->default(false);
            $table->boolean('flEmitirCFEAutomaticamente')->default(false);
            $table->integer('idContaFinanceiro')->default(19);
            $table->boolean('flAtivo')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mobyo_config');
    }
}
