<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMobyoPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('mobyo_payments')) {
            Schema::create('mobyo_payments', function (Blueprint $table) {
                $table->id();
                $table->string('name', 50);
                $table->unsignedBigInteger('idMobyoConfig');
                $table->foreign('idMobyoConfig')->references('id')->on('mobyo_config');
                $table->integer('idFormaPagamento');
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mobyo_payments');
    }
}
