<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVwSalesByMonth extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!$this->hasView('vw_sales_by_month')) {
            DB::statement("
                create view [dbo].[vw_sales_by_month] as
                select
                count(1) as qtdVendas,
                cast(year(dtData) as varchar(4)) + '-' + replicate('0', 2-len(month(dtData))) + cast(month(dtData) as varchar(2)) + '-01'  as 'dtData',
                sum(vrTotalBruto) as totalBruto,
                sum(vrAcrescimo) as acrescimo,
                sum(vrDesconto) as desconto,
                sum(vrTotal) as total
                from sales_list
                where flAtivo = 1
                group by cast(year(dtData) as varchar(4)) + '-' + replicate('0', 2-len(month(dtData))) + cast(month(dtData) as varchar(2)) + '-01'
            ");
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $nameView = 'vw_sales_by_month';
        DB::statement($this->dropView($nameView));
    }

    private function dropView($nameView)
    {
        return "if exists(select 1 from sys.views where name= '" . $nameView . "' and type='v')
                drop view " . $nameView . ";";
    }
    private function hasView($name)
    {
        $hasView = DB::select(
            "SELECT
                CASE WHEN EXISTS
                    (
                        SELECT 1 from sys.views where name = '" . $name . "' and type = 'v'
                    )
                    THEN 1
                    --ELSE 0
            END as result"
        );
        return $hasView[0]->result;
    }
}
