<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFinBandeirasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('fin_Bandeiras')) {

            DB::statement('CREATE TABLE [dbo].[fin_Bandeiras](
                  [idBandeira] [smallint] NOT NULL,
                  [stBandeira] [nvarchar](20) NOT NULL,
                  [dtAlteracao] [datetime] NOT NULL CONSTRAINT [DF_fin_Bandeiras_dtAlteracao]  DEFAULT (getdate()),
                  [vrPorcentagemJuros] [decimal](9, 2) NULL CONSTRAINT [DF_fin_Bandeiras_vrPorcentagemJuros]  DEFAULT ((0.00)),
                  [flCredito] [smallint] NOT NULL CONSTRAINT [DF_fin_Bandeiras_flCredito]  DEFAULT ((0)),
                  [vrTaxaCredito] [decimal](5, 2) NOT NULL DEFAULT (\'0\'),
                  [vrTaxaDebito] [decimal](5, 2) NOT NULL DEFAULT (\'0\'),
                  CONSTRAINT [PK_fin_Bandeiras] PRIMARY KEY CLUSTERED
                    (
                      [idBandeira] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fin_Bandeiras');

    }
}
