<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFinConfigAdquirenteTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('fin_ConfigAdquirente')) {

            DB::statement('CREATE TABLE [dbo].[fin_ConfigAdquirente](
                  [idConfigAdq] [smallint] NOT NULL,
                  [txDebito] [decimal](5, 2) NULL,
                  [txCredito] [decimal](5, 2) NULL,
                  [diasPgtoDebito] [smallint] NULL,
                  [diasPgtoCredito] [smallint] NULL,
                  [idContaBancaria] [smallint] NOT NULL,
                  [idFormaPagamento] [smallint] NOT NULL,
                  [idCredenciadora] [smallint] NULL,
                  [dtAlteracao] [datetime] NOT NULL,
                  CONSTRAINT [PK_fin_ConfigAdquirente] PRIMARY KEY CLUSTERED
                    (
                      [idConfigAdq] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fin_ConfigAdquirente');

    }
}
