<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFinItensContaBancariaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('fin_ItensContaBancaria')) {

            DB::statement('CREATE TABLE [dbo].[fin_ItensContaBancaria](
                  [idItemConta] [int] NOT NULL,
                  [idContaBancaria] [smallint] NOT NULL,
                  [dtData] [smalldatetime] NOT NULL,
                  [stDescricao] [nvarchar](100) NOT NULL,
                  [stDocumento] [nvarchar](100) NULL,
                  [vrDocumento] [decimal](9, 2) NOT NULL,
                  [vrSaldoAnterior] [decimal](9, 2) NOT NULL,
                  [idContaPagarReceber] [int] NOT NULL,
                  [idCliente] [smallint] NULL,
                  [idFornecedor] [smallint] NULL,
                  [flCheque] [bit] NOT NULL,
                  [dtAlteracao] [datetime] NOT NULL,
                  CONSTRAINT [PK_fin_ItensContaBancaria] PRIMARY KEY CLUSTERED
                    (
                      [idItemConta] ASC,
                      [idContaBancaria] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fin_ItensContaBancaria');
    }
}
