<link href="resources/css/bootstrap.min.css" rel="stylesheet"/>
<link href="resources/css/datatables.min.css" rel="stylesheet" type="text/css"/>
<link href="resources/css/toastr.css" rel="stylesheet"/>
<link href="resources/css/sweetalert2.css" rel="stylesheet"/>
<link href="resources/css/custom.css" rel="stylesheet"/>
<?php
error_reporting(0);

require_once "functions.php";

if (strstr($_SERVER['SCRIPT_NAME'], "index.php") === false)
{
	redirect("index.php");
	die;
}

permission(59);

$stDate = $_GET['date'];
$type = $_GET['type'];
$agen = $_GET['agen'];

if (!$stDate)
{
	$dtDe = date("Y-m-d", strtotime("-24 hours"));
	$dtAte = date("Y-m-d");
}
else
{
	$stDate = explode("@", $stDate);

	$dtDe = $stDate[0];
	$dtAte = $stDate[1];

	$dtDe_ = explode("-", $dtDe);
	$dtAte_ = explode("-", $dtAte);
}

?>
<div class="col-md-8 col-md-offset-2" align="center">
    <h2>Lista de Orçamentos</h2>
</div>
<script>
	function filterList()
	{
		if (validateListaPedidos() == false)
			return;

		var typ = "";
        var age = "";

		if (document.filterPedido.X.checked == true)
			typ = 'X';
        if (document.filterPedido.A.checked == true)
            age = 'A';

		var per = document.filterPedido.dtDe_ano.value+'-'+
				  document.filterPedido.dtDe_mes.value+'-'+
				  document.filterPedido.dtDe_dia.value+'@'+
				  document.filterPedido.dtAte_ano.value+'-'+
				  document.filterPedido.dtAte_mes.value+'-'+
				  document.filterPedido.dtAte_dia.value;

		document.location = '?sec=listaOrcamentos&type='+typ+'&agen='+age+'&date='+per;
	}
</script>
<form name="filterPedido">
<div class="col-md-12" align="center">
<table class="tableForm" style="width: auto">
	<tr>
		<td>
		<input type="text" size="1" name="dtDe_dia" maxlength="2" value="<?=(!$dtDe_[2] ? date("d", strtotime("-24 hours")) : $dtDe_[2])?>" onkeypress="return removeInvalidChars(event, '0123456789');" /> /
		<input type="text" size="1" name="dtDe_mes" maxlength="2" value="<?=(!$dtDe_[1] ? date("m", strtotime("-24 hours")) : $dtDe_[1])?>" onkeypress="return removeInvalidChars(event, '0123456789');" /> /
		<input type="text" size="3" name="dtDe_ano" maxlength="4" value="<?=(!$dtDe_[0] ? date("Y", strtotime("-24 hours")) : $dtDe_[0])?>" onkeypress="return removeInvalidChars(event, '0123456789');" />
		até
		<input type="text" size="1" name="dtAte_dia" maxlength="2" value="<?=(!$dtAte_[2] ? date("d") : $dtAte_[2])?>" onkeypress="return removeInvalidChars(event, '0123456789');" /> /
		<input type="text" size="1" name="dtAte_mes" maxlength="2" value="<?=(!$dtAte_[1] ? date("m") : $dtAte_[1])?>" onkeypress="return removeInvalidChars(event, '0123456789');" /> /
		<input type="text" size="3" name="dtAte_ano" maxlength="4" value="<?=(!$dtAte_[0] ? date("Y") : $dtAte_[0])?>" onkeypress="return removeInvalidChars(event, '0123456789');" />
		</td>
	</tr>
</table>
</div>
<table class="tableForm">
	<tr>
		<td><input type="checkbox" name="X" value="true" <?=($type == "X" ? "checked='checked'" : "")?> /> EXCLUIDOS</td>
        <td><input type="checkbox" name="A" value="true" <?=($agen == "A" ? "checked='checked'" : "")?> /> AGÊNDAMENTOS</td>
		<td align="right"><input class="btn btn-primary" type="button" name="btn" value="Filtrar" onclick="filterList();" /></td>
	</tr>
</table>
</form>
<form name="selectPedido" method="post" action="?sec=montarOrcamento">
<table class="table table-bordered">
	<thead>
		<th>NÚMERO</th>
		<th>CLIENTE</th>
		<th>INICIADO</th>
		<th>STATUS</th>
		<th><center>ALTERAR</center></th>
		</thead>

<tbody>
<?

$sql = "SELECT A.*, C.stCliente, M.stMotoBoy FROM dlv_Atendimentos A ".
	   "INNER JOIN dlv_Clientes C ON A.idCliente = C.idCliente ".
	   "LEFT JOIN dlv_Motoboy M ON A.idMotoboy = M.idMotoboy ".
	   "WHERE dtAbertura BETWEEN '$dtDe 00:00:00' AND '$dtAte 23:59:59' ".
       "AND A.flAtivo IN ('1'".($type == "X" ? ",'0'" : "").") ".
       "AND A.flAgendarPedido IN ('0'".($agen == "A" ? ",'1'" : "").") ".
       "AND A.flOrcamento = '1' ".
	   "ORDER BY A.idAtendimento DESC";

$res = mssql_query($sql);

while ($arr = mssql_fetch_array($res))
{
	$stStatus = "";
	$nrOciosidade = 0;
	$stCor = "#FFFFFF";

	if (!$arr['flAtivo'])
	{
		$stStatus = "EXCLUIDO";
		$stCor = "#FF9999";
	}
	else
	{
		switch ($arr['stStatus'])
		{
			case "F":
				if ($arr['flAgendarPedido'] && date("Y-m-d H:i", strtotime($arr['dtAgendarPedido'])) > date("Y-m-d H:i", strtotime("+2 hours")))
					$stStatus = "<a title='PARA: ".date("d/m/Y H:i", strtotime($arr['dtAgendarPedido']))."'>AGENDADO</a>";
				else
					$stStatus = "FORMULAÇÃO";

				$stCor = "#F0F0F0";
				break;
		}
	}

	?>
	<tr bgcolor="<?=$stCor?>">
		<td><?=$arr['idAtendimento']?></td>
		<td><?=$arr['stCliente']?></td>
		<td><?=date("d/m/Y H:i", strtotime($arr['dtAbertura']))?> H</td>
		<?
		if (($arr['stStatus'] == "S" || $arr['stStatus'] == "E") && $arr['flAtivo'] == true)
		{
			echo "<td><a title='ENTREGADOR: ".$arr['stMotoBoy']."'>$stStatus</a>".($arr['flPago'] ? " [PAGO]" : "")."</td>";
		}
		else
			echo "<td>$stStatus</td>";
		?>
		<td align="center">
		<a class="btn btn-primary btn-sm" onclick="NewWindow('ver.php?id=<?=$arr['idAtendimento']?>','ver','405','500','yes','center'); return false;"><span class="glyphicon glyphicon-search" alt="Visualizar"></span></a>
		<?
		if ($arr['flAtivo'])
		{
			?>
			<a class="btn btn-info btn-sm" href="takeConvertOrcamento.php?id=<?=$arr['idAtendimento']?>" onclick="return confirm('Tem certeza que deseja transformar este orçamento em um pedido?')"><span class="glyphicon glyphicon-refresh" alt="Converter em Pedido"></span></a>
			<?
			if ($arr['stStatus'] == "F")
			{
				?>
				<a class="btn btn-success btn-sm" href="index.php?sec=montarOrcamento&id=<?=$arr['idAtendimento']?>" onclick="return verifyOperador('<?=$arr['idOperador']?>', '<?=$UID?>', '', '<?=$arr['idAtendimento']?>');"><span class="glyphicon glyphicon-pencil" alt="Editar"></span></a>
				<a class="btn btn-danger btn-sm" href="index.php?sec=removerAtendimento&id=<?=$arr['idAtendimento']?>" onclick="return verifyOperador('<?=$arr['idOperador']?>', '<?=$UID?>', 'Tem certeza que deseja cancelar este orçamento?', '<?=$arr['idAtendimento']?>');"><span class="glyphicon glyphicon-remove" alt="Cancelar"></span></a>
				<a class="btn btn-warning btn-sm" onclick="NewWindow('reImprimirOrcamento.php?id=<?=$arr['idAtendimento']?>','reImprimir','400','200','yes','center'); return false;"><span class="glyphicon glyphicon-print" alt="Re-Imprimir"></span></a>
				<?
			}
		}
		?>
		</td>
	</tr>
	<?
}
?>
</tbody>
</table>
</form>
<script src="resources/js/jquery-2.1.4.js"></script>
<script src="resources/js/bootstrap.min.js"></script>
<script src="resources/js/datatables.min.js"></script>
<script src="resources/js/toastr.js"></script>
<script src="resources/js/sweetalert2.min.js"></script>
<script src="resources/js/functions.js"></script>
