<?php


namespace App\Entities\Mobyo;


use Carbon\Carbon;
use Illuminate\Support\Str;
use App\Entities\Delivery\MobyoConfig;

class Order
{
    private $reference;
    private $subTotal;
    private $totalPrice;
    private $deliveryFee;
    private $createdAt;
    private $benefits;
    private $items;
    private $scheduled;
    private $deliveryAddress;
    private $deliveryDateTime;
    private $preparationStartDateTime;
    private $customer;
    private $shortReference;
    private $localizer;
    private $engineType;
    private $config;
    protected $engine;
    private $service;
    private $orderType;
    private $delivery;
    private $discount;

    public function __construct(array $data = array())
    {
        $this->reference = $data['reference'];
        $this->engineType = isset($data['engineType']) ? $data['engineType'] : 'null';
        $this->subTotal = $data['total']['subTotal'];
        $this->totalPrice = $data['total']['orderAmount'];
        $this->deliveryFee = $data['total']['deliveryFee'];
        $this->setCreatedAt($data['createdAt']);
        $this->orderType = $data['orderType'];
        $this->shortReference = isset($data['displayId']) ? $data['displayId'] : 'null';
        $this->localizer = isset($data['localizer']) ? $data['localizer'] : '';
        $this->items = isset($data['items']) ? $data['items'] : [];
        $this->benefits = $data['total']['benefits'];
        $this->scheduled = isset($data['orderTiming']) && $data['orderTiming'] == 'SCHEDULED' ? true : false;
        $this->deliveryAddress = isset($data['delivery']['deliveryAddress']) ? $data['delivery']['deliveryAddress'] : [];
        $this->customer = isset($data['customer']) ? $data['customer'] : [];
        $this->setPreparationStartDateTime(isset($data['preparationStartDateTime']) ? $data['preparationStartDateTime'] : '');
        $this->setDeliveryDateTime(isset($data['deliveryDateTime']) ? $data['deliveryDateTime'] : '');
        $this->engine = $this->getIntegrationFromDB($data);
        $this->service = isset($data['service']) ? $data['service'] : 0;
        $this->delivery = isset($data['delivery']) ? $data['delivery'] : [];
        $this->discount = isset($data['total']['benefits']) ? $data['total']['benefits'] : 0;
    }

    public function isIfoodmercado($order)
    {
        if($order['engineName'] === 'IFOOD MERCADO') {
            return true;
        }
        return false;
    }

    public function getIntegrationFromDB($request)
    {
        try {
            if($this->isIfoodmercado($request)) {
                $this->engineType = $request['engineName'];
                $integration = MobyoConfig::where('engine', $request['engineName'])
                                            ->with('payments')
                                            ->first();
            } else {
                $integration = MobyoConfig::where('engine', $request['engineType'])
                                            ->with('payments')
                                            ->first();
            }
            return $integration;
        } catch (\Exception $e) {
            throw new \Exception($e);
        }

    }

    private function setCreatedAt($value)
    {
        $this->createdAt = Carbon::parse($value)->timezone('America/Sao_Paulo');
    }

    public function setPreparationStartDateTime($value)
    {
        $this->preparationStartDateTime = Carbon::parse($value)->timezone('America/Sao_Paulo');
    }

    public function getPreparationStartDateTime()
    {
        return $this->preparationStartDateTime;
    }

    public function getEngineType()
    {
        return $this->engineType;
    }

    public function getComplemento()
    {
        return isset($this->deliveryAddress['complement'])
            ? $this->trataString($this->deliveryAddress['complement'])
            : '';
    }

    public function getAddress($data = null)
    {
        if (!$data) {
            return $this->deliveryAddress;
        } else {
            return $this->trataString($this->deliveryAddress[$data]);
        }
    }

    public function getAddressReference()
    {
        return isset($this->deliveryAddress['reference'])
            ? $this->trataString($this->deliveryAddress['reference']) : '';
    }

    public function getPhone()
    {
        return isset($this->customer['phone']['number']) ? $this->customer['phone']['number'] : '';
    }

    public function getCustomerName()
    {
        return isset($this->customer['name']) ? $this->customer['name'] : '';
    }

    public function getOrderReference()
    {
        return $this->reference;
    }

    public function getShortReference()
    {
        return isset($this->shortReference) ? $this->shortReference : '';
    }

    public function getLocalizador()
    {
        return isset($this->localizer['id'])
            ? $this->localizer['id']
            : '';
    }

    public function getOrdersCount()
    {
        return isset($this->customer['ordersCountOnRestaurant'])
            ? $this->customer['ordersCountOnRestaurant']
            : 1;
    }

    public function getFormatedAddress()
    {
        return isset($this->deliveryAddress['formattedAddress'])
            ? $this->trataString($this->deliveryAddress['formattedAddress'])
            : "";
    }

    public function setDeliveryDateTime($value)
    {
        $this->deliveryDateTime = Carbon::parse($value)->timezone('America/Sao_Paulo');
    }

    public function getDeliveryDateTime()
    {
        return $this->deliveryDateTime;
    }

    public function getDocumentNumber()
    {
        return isset($this->customer['documentNumber'])
            ? str_replace(['.', '-', '/'], '', $this->customer['documentNumber'])
            : null;
    }

    public function getCustomer()
    {
        return isset($this->customer['name']) ? Str::upper($this->customer['name']) : '';
    }

    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    public function getClienteRetira()
    {
        return $this->orderType == 'TAKEOUT';
    }

    public function setDeliveryMethod($method)
    {
        $this->delivery['deliveredBy'] = $method;
    }

    public function setScheduled($scheduled)
    {
        $this->scheduled = $scheduled;
    }

    public function getScheduled()
    {
        return $this->scheduled;
    }

    public function getDeliveredBy()
    {
        return $this->delivery['deliveredBy'];
    }

    public function getReference()
    {
        return $this->reference;
    }

    public function getDeliveryFee()
    {
        return $this->deliveryFee;
    }

    public function setItem($item)
    {
        if (isset($item))
            $it = [

            ];
        array_push($this->items, $item);
    }

    public function getItems()
    {
        return $this->items;
    }

    public function getTotal()
    {
        $subTotal = $this->subTotal;
        $fee = 0;
        $service = $this->service;

        if ($this->engine['flSalvarTaxaEntrega']) $subTotal += $this->deliveryFee;

       $fee += $this->getDesconto();
       $subTotal -= $fee;

       $subTotal += $service;

        return $subTotal;
    }

    private function calculateTotalWithDeliveryFee($total, $fee)
    {
        $benefits = $this->getBenefits('DELIVERY_FEE');
        foreach ($benefits as $be) {
            if ($be['sponsorshipValues']['MERCHANT'] > 0) {
                $fee += $be['value'];
            }
        }
        return $total += ($this->deliveryFee - $fee);
    }


    public function getDesconto()
    {
        if(!$this->engine->flSalvarDesconto) {
            return 0;
        }
        return $this->discount;
    }

    private function getBenefits($target = '')
    {
        try {
            return array_filter($this->benefits, function ($it) use ($target) {
                return $it['target'] == $target;
            });
        } catch (\Exception $e) {
            return [];
        }
    }

    private function trataString($string)
    {
        $comAcentos = array('à', 'á', 'â', 'ã', 'ä', 'å', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ù', 'ü', 'ú', 'ÿ', 'À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'O', 'Ù', 'Ü', 'Ú');
        $semAcentos = array('a', 'a', 'a', 'a', 'a', 'a', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'y', 'A', 'A', 'A', 'A', 'A', 'A', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'N', 'O', 'O', 'O', 'O', 'O', '0', 'U', 'U', 'U');

        return str_replace($comAcentos, $semAcentos, $string);
    }

    private function setService($service)
    {
        $this->service = $service;
    }

    public function getService()
    {
        return $this->service;
    }
}
