<?php

namespace App\Entities;

use App\Entities\Nati\Key;
use Illuminate\Database\Eloquent\Model;
//use OwenIt\Auditing\Contracts\Auditable;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class PontoDelivery extends Model implements Transformable
{
    use TransformableTrait;
//

    protected $table = 'dlv_Config';
    protected $primaryKey = 'idDelivery';
    protected $keyType = 'string';
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idDelivery',
        'stMarcaPrint',
        'stTipoPorta',
        'nrDddPadrao',
        'stRodapeCupom',
        'stCabecalhoCupom1',
        'stCabecalhoCupom2',
        'stCabecalhoCupom3',
        'stCabecalhoCupom4',
        'stCidade',
        'stEstado',
        'nrVias',
        'idMicroterminal',
        'flTaxaEntregaUnica',
        'vrTaxaEntregaUnica',
        'nrAlertaEntrega',
        'flSolicitarOperador',
        'flAtivo',
        'flPrintCupomPreparo',
        'dtAlteracao',
        'flPrintManager',
        'flAssumirPedido',
        'flHorarios',
        'stLinkPagtel'
    ];

    protected $appends = [
        'key'
    ];

    protected $casts = [
        'flTaxaEntregaUnica' => 'bool',
        'flSolicitarOperador' => 'bool',
        'flAtivo' => 'bool',
        'flPrintCupomPreparo' => 'bool',
        'flPrintManager' => 'bool',
        'flAssumirPedido' => 'bool',
        'flHorarios' => 'bool',
    ];

    public function getKeyAttribute()
    {
        $key = Key::where('stComponente', $this->idDelivery)->get('stChave')->first();
        return isset($key['stChave'])?$key['stChave']: '';
    }
    public function key()
    {
        return $this->hasOne(Key::class, 'stComponente', 'idDelivery');
    }

}
