<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Services\Nati\LocalizacaoService;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;

use App\Http\Requests;
use Prettus\Validator\Contracts\ValidatorInterface;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\Nati\LocalizacaoCreateRequest;
use App\Http\Requests\Nati\LocalizacaoUpdateRequest;
use App\Repositories\Nati\LocalizacaoRepository;
use App\Validators\Nati\LocationValidator;


class LocalizacoesController extends Controller
{
    protected $service;

    public function __construct(LocalizacaoService $service)
    {
        $this->service = $service;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try
        {
            $localizacoes = $this->service->all();

            return response()->json($localizacoes);
        }
        catch(\Exception $exception)
        {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  LocalizacaoCreateRequest $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(LocalizacaoCreateRequest $request)
    {
        try {
            $localizacao = $this->service->create($request->all());

            $response = [
                'message' => 'Localizacao created.',
                'data'    => $localizacao->toArray(),
            ];
            return response()->json($response, 201);

        }catch (ModelNotFoundException $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessageBag()
            ], 400);
        }
        catch (ValidatorException $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessageBag()
            ], 404);
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try
        {
            $localizacao = $this->service->getById($id);

            return response()->json($localizacao);
        }
        catch(\Exception $exception)
        {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  LocalizacaoUpdateRequest $request
     * @param  string            $id
     *
     * @return Response
     */
    public function update(LocalizacaoUpdateRequest $request, $id)
    {
        try {
            $localizacao = $this->service->update($request->all(), $id);
            return response()->json([
                'message' => 'Localizacao Update',
                'data' => $localizacao
            ],201);


        }catch (ModelNotFoundException $e)
        {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);

        } catch (ValidatorException $e) {

            return response()->json([
                'error'   => true,
                'message' => $e->getMessageBag()
            ], 404);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        try {
            $localizacao = $this->service->delete($id);

            $response = [
                'message' => 'Localizacao deletada.',
                'data'    => $localizacao,
            ];
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessage()
            ], 400);

        }
    }
}
