<?php
/**
 * Created by PhpStorm.
 * User: ARCNET DEV
 * Date: 27/10/2017
 * Time: 16:38
 */

namespace App\Http\Controllers;

use App\Services\Nati\TabelaNutricionalService;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Prettus\Validator\Exceptions\ValidatorException;

class TabelaNutricionalController
{
    protected $service;

    public function __construct(TabelaNutricionalService $service)
    {
        $this->service = $service;
    }

    public function show($id) {
        try {
            return $this->service->getById($id);

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => 'true',
                'message' => $e->getMessage()
            ]);
        }
    }

    public function update(Request $request, $id) {
        try {
            return $this->service->upsert($request->all(), $id);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ]);

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ]);
        }
    }
}
