<?php

namespace App\Repositories;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\EntradaSaidaRepository;
use App\Entities\EntradaSaida;
use App\Validators\EntradaSaidaValidator;

/**
 * Class EntradaSaidaRepositoryEloquent
 * @package namespace App\Repositories;
 */
class EntradaSaidaRepositoryEloquent extends BaseRepository implements EntradaSaidaRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return EntradaSaida::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return EntradaSaidaValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
