<?php


namespace App\Services\Nati;

use App\Entities\ProductComposite;
use App\Repositories\ProductCompositeRepository;
use App\Validators\ProductCompositeValidator;
use Carbon\Carbon;
use Prettus\Validator\Contracts\ValidatorInterface;

class ProductCompositeService
{
    private $repository;
    private $validator;


    public function __construct(ProductCompositeRepository $repository, ProductCompositeValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function create($id_product, $request)
    {
        $date = Carbon::now();

        foreach ($request as $item) {

            $this->validator->with($request)->passesOrFail(ValidatorInterface::RULE_CREATE);

            $datasheet = [
                'idProdutoPrincipal' => $id_product,
                'idItem' => $this->getNextId($id_product),
                'idProduto' => $item['idProduto'],
                'nrQuantidade' => $item['nrQuantidade'],
                'vrCustoTotal' => $item['vrCustoTotal'],
                'dtAlteracao' => $date
            ];

            $this->repository->create($datasheet);
        }
        return true;
    }


    public function delete($id)
    {
        return ProductComposite::where('idProdutoPrincipal', $id)->delete();
    }

    private function getNextId($id_product)
    {
        return $aliquota = ProductComposite::where('idProdutoPrincipal', $id_product)->max('idItem') + 1;
    }

}
