<?php
/**
 * Created by PhpStorm.
 * User: Kaio F.
 * Date: 09/10/2017
 * Time: 16:28
 */

namespace App\Services\Nati;

use App\Entities\Nati\SaldoEstoque;
use App\Repositories\Nati\SaldoEstoqueRepository;
use App\Services\Service;
use App\Validators\SaldoEstoqueValidator;
use Carbon\Carbon;
use Prettus\Validator\Contracts\ValidatorInterface;

class SaldoEstoqueService extends Service
{
    protected $repository;
    protected $validator;

    public function __construct(SaldoEstoqueRepository $repository, SaldoEstoqueValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function get()
    {
        return $this->repository->all();
    }

    public function getById($id)
    {
        return $this->repository->with('estoque')->findWhere(['idProduto' => $id]);
    }

    public function insert($data, $increment = false)
    {
        //$item[0] = idProduto
        //$item[1] = nrQuantidade
        //$item[2] = idEstoque
        collect($data)->each(function($item) use($increment) {
            $idProduto = $item[0];
            $nrQuantidade = $item[1];
            $idEstoque = isset($item[2]) ? $item[2] : 1;
            // Verifica se já existe produto no estoque e atualiza quantidade
            $model = $this->repository->findWhere(['idProduto' => $idProduto, 'idEstoque' => $idEstoque])->first();
            // Alterando o valor atual
            if (count($model) != 0 && !$increment)
                return $this->update(['nrQuantidade' => $nrQuantidade], $model->idSaldo);
            // Ou incrementando o mesmo
            elseif (count($model) != 0 && $increment)
                return $this->addEstoque($nrQuantidade, $model);
            // Se não houver cria um novo registro
            else {
                $now = Carbon::now();
                return $this->repository->create([
                    'idSaldo' => SaldoEstoque::max('idSaldo') + 1,
                    'idEstoque' => $idEstoque,
                    'idProduto' => $idProduto,
                    'nrQuantidade' => $nrQuantidade,
                    'nrReservas' => 0,
                    'nrMinimo' => 0,
                    'dtModificacao' => $now,
                    'dtConferencia' => $now,
                    'dtAlteracao' => $now,
                ]);
            }
        });
        return true;
    }

    public function addEstoque($qtd, $model) {
        $model->nrQuantidade = floatval($model->nrQuantidade += floatval($qtd));
        $model->save();
        return $model;
    }

    public function update($data, $id)
    {
        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_UPDATE);
        $model = $this->repository->find($id);

        return $data['nrQuantidade'] == true
            ? $this->addEstoque($data['nrQuantidade'], $model)
            : $this->repository->update($data, $id);
    }

    public function upsert($data, $id)
    {
        if ($this->repository->find($id))
            $this->repository->create($data);
    }

    public function delete($id)
    {
        return $this->repository->delete($id);
    }

    public function mapToEntity($data)
    {

    }

    public function updateMinimumStock($data)
    {
        try {
            foreach($data as $item) {
                $this->repository->update(
                    [
                        'nrMinimo' => $item['estoqueMinimo'],
                        'dtAlteracao' => Carbon::now(),
                    ],
                    $item['idSaldo']
                );
            }
            return response('Success', 201);
        } catch (\Exception $e) {
            throw new \Exception($e);
        }

    }
}
