<?php

namespace App\Validators;

use \Prettus\Validator\Contracts\ValidatorInterface;
use \Prettus\Validator\LaravelValidator;

class SaldoEstoqueValidator extends LaravelValidator
{

    protected $rules = [
        ValidatorInterface::RULE_CREATE => [
            'idSaldo'       => 'required|integer',
            'idEstoque'     => 'required|integer',
            'idProduto'     => 'required|integer',
            'nrQuantidade'  => 'required|numeric',
            'nrReservas'    => 'required|numeric',
            'dtModificacao' => 'required|datetime',
            'dtConferencia' => 'required|datetime',
            'nrMinimo'      => 'numeric|nullable',
            'dtAlteracao'   => 'datetime',
            'nrConferido'   => 'numeric|nullable'
        ],
        ValidatorInterface::RULE_UPDATE => [
            'nrQuantidade'  => 'numeric',
            'nrReservas'    => 'numeric',
            'dtModificacao' => 'datetime',
            'dtConferencia' => 'datetime',
            'nrMinimo'      => 'numeric|nullable',
            'dtAlteracao'   => 'datetime',
            'nrConferido'   => 'numeric|nullable'
        ],
   ];
}
