<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCxVaucherTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cx_Vaucher')) {
            Schema::create('cx_Vaucher', function (Blueprint $table) {
                $table->integer('idAbertura');
                $table->integer('idCaixa');
                $table->integer('idVaucher');
                $table->decimal('vrVaucher', 9, 2);
                $table->integer('idFormaPagamento');
                $table->integer('idOperador');
                $table->integer('idOperadorAutorizador');
                $table->dateTime('dtDataEmissao');
                $table->boolean('flAtivo');
                $table->integer('idPedido');
                $table->boolean('flLiquidado');
                $table->string('stPrint')->nullable(true);
                $table->dateTime('dtEmissao');
                $table->dateTime('dtAlteracao');

            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cx_Vaucher');
    }
}
