<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterTriggerFechamentoCaixa extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if($this->triggerExists()) {
            DB::statement("
                ALTER TRIGGER [dbo].[FECHAMENTO_CAIXA]
                ON [dbo].[cx_Gerenciador]
                AFTER UPDATE
                AS
                BEGIN
                    DECLARE @ID INT
                    DECLARE @ABERTO BIT
                    DECLARE @CONF BIT
                    DECLARE @CONF_FROM BIT

                    IF EXISTS (SELECT * FROM INSERTED)
                    BEGIN
                        SET NOCOUNT ON
                        SET @ID = (SELECT idAbertura FROM INSERTED)
                        SET @ABERTO = (SELECT flAberto FROM INSERTED)
                        SET @CONF = (SELECT flConferencia FROM INSERTED)
                        SET @CONF_FROM = (SELECT flConferencia FROM DELETED)

                        IF @ABERTO = 0 AND @CONF = 1 AND @CONF_FROM = 0
                        BEGIN
                            SET NOCOUNT ON
                            INSERT INTO cx_Vendas SELECT * FROM cx_Vendas_Temp WHERE idAbertura = @ID
                            INSERT INTO cx_Itens SELECT * FROM cx_Itens_Temp WHERE idAbertura = @ID
                            INSERT INTO cx_FichaPagamentos SELECT * FROM cx_FichaRecebimentos_Temp WHERE idAbertura = @ID

                            BEGIN
                            SET NOCOUNT ON
                                /*INSERT INTO [dbo].[int_conciliation] ([id],[codigo_tipo_produto],[codigo_autorizacao], [data_venda],[data_vencimento],[valor_venda_parcela],[total_venda],[parcela],[total_parcelas],[nsu],[terminal],[meio_captura],[flConciliado],[venda_id],[abertura_id],[created_at])
                                select (select NEWID())as id,'00' as [codigo_tipo_produto], autorizacao as [codigo_autorizacao], dtdata as [data_venda],GETDATE() as [data_vencimento], vrFormaPagamento as [valor_venda_parcela],vrFormaPagamento as [total_venda],0 as [parcela],0 as [total_parcelas], [nsu],1 as [terminal],1 as [meio_captura],'0' as [flConciliado],idVenda as  [venda_id],idAbertura as [abertura_id],GETDATE() as [created_at]
                                from cx_FichaPagamentos fp
                                inner join cx_FormasPagamento f on f.idFormaPagamento = fp.idFormaPagamento
                                inner join cx_TiposFormaPagamento t on f.idTipo = t.idTipoForma
                                where idAbertura = @ID and f.idTipo = 2 and f.flAtivo = 1 and fp.flSentConciliacao = 0*/

                                --update cx_FichaPagamentos set flSentConciliacao = 1 where idAbertura = @ID and flAtivo = 1


                                DELETE FROM cx_Vendas_Temp WHERE idAbertura = @ID
                                DELETE FROM cx_Itens_Temp WHERE idAbertura = @ID
                                DELETE FROM cx_FichaRecebimentos_Temp WHERE idAbertura = @ID

                                IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'cx_Vendas' AND COLUMN_NAME = 'dtAlteracao') UPDATE cx_Vendas SET dtAlteracao = GETDATE() WHERE idAbertura = @ID
                                IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'cx_Itens' AND COLUMN_NAME = 'dtAlteracao') UPDATE cx_Itens SET dtAlteracao = GETDATE() WHERE idAbertura = @ID
                                IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'cx_FichaPagamentos' AND COLUMN_NAME = 'dtAlteracao') UPDATE cx_FichaPagamentos SET dtAlteracao = GETDATE() WHERE idAbertura = @ID
                            END
                        END
                    END
                END
            ");
        } else {
            DB::statement("
                        CREATE TRIGGER [dbo].[FECHAMENTO_CAIXA]
                        ON [dbo].[cx_Gerenciador]
                        AFTER UPDATE
                        AS
                        BEGIN
                            DECLARE @ID INT
                            DECLARE @ABERTO BIT
                            DECLARE @CONF BIT
                            DECLARE @CONF_FROM BIT

                            IF EXISTS (SELECT * FROM INSERTED)
                            BEGIN
                                SET NOCOUNT ON
                                SET @ID = (SELECT idAbertura FROM INSERTED)
                                SET @ABERTO = (SELECT flAberto FROM INSERTED)
                                SET @CONF = (SELECT flConferencia FROM INSERTED)
                                SET @CONF_FROM = (SELECT flConferencia FROM DELETED)

                                IF @ABERTO = 0 AND @CONF = 1 AND @CONF_FROM = 0
                                BEGIN
                                    SET NOCOUNT ON
                                    INSERT INTO cx_Vendas SELECT * FROM cx_Vendas_Temp WHERE idAbertura = @ID
                                    INSERT INTO cx_Itens SELECT * FROM cx_Itens_Temp WHERE idAbertura = @ID
                                    INSERT INTO cx_FichaPagamentos SELECT * FROM cx_FichaRecebimentos_Temp WHERE idAbertura = @ID

                                    BEGIN
                                    SET NOCOUNT ON
                                        /*INSERT INTO [dbo].[int_conciliation] ([id],[codigo_tipo_produto],[codigo_autorizacao], [data_venda],[data_vencimento],[valor_venda_parcela],[total_venda],[parcela],[total_parcelas],[nsu],[terminal],[meio_captura],[flConciliado],[venda_id],[abertura_id],[created_at])
                                        select (select NEWID())as id,'00' as [codigo_tipo_produto], autorizacao as [codigo_autorizacao], dtdata as [data_venda],GETDATE() as [data_vencimento], vrFormaPagamento as [valor_venda_parcela],vrFormaPagamento as [total_venda],0 as [parcela],0 as [total_parcelas], [nsu],1 as [terminal],1 as [meio_captura],'0' as [flConciliado],idVenda as  [venda_id],idAbertura as [abertura_id],GETDATE() as [created_at]
                                        from cx_FichaPagamentos fp
                                        inner join cx_FormasPagamento f on f.idFormaPagamento = fp.idFormaPagamento
                                        inner join cx_TiposFormaPagamento t on f.idTipo = t.idTipoForma
                                        where idAbertura = @ID and f.idTipo = 2 and f.flAtivo = 1 and fp.flSentConciliacao = 0*/

                                        --update cx_FichaPagamentos set flSentConciliacao = 1 where idAbertura = @ID and flAtivo = 1


                                        DELETE FROM cx_Vendas_Temp WHERE idAbertura = @ID
                                        DELETE FROM cx_Itens_Temp WHERE idAbertura = @ID
                                        DELETE FROM cx_FichaRecebimentos_Temp WHERE idAbertura = @ID

                                        IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'cx_Vendas' AND COLUMN_NAME = 'dtAlteracao') UPDATE cx_Vendas SET dtAlteracao = GETDATE() WHERE idAbertura = @ID
                                        IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'cx_Itens' AND COLUMN_NAME = 'dtAlteracao') UPDATE cx_Itens SET dtAlteracao = GETDATE() WHERE idAbertura = @ID
                                        IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'cx_FichaPagamentos' AND COLUMN_NAME = 'dtAlteracao') UPDATE cx_FichaPagamentos SET dtAlteracao = GETDATE() WHERE idAbertura = @ID
                                    END
                                END
                            END
                        END
            ");
        };

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }

    private function triggerExists()
    {
        $res = DB::select("
            if exists (select 1 from sys.triggers where name = 'FECHAMENTO_CAIXA')
            begin
                select isTrue = 1
            end
            else
                select isTrue = 0
        ");

        if($res[0]->isTrue == "1") {
            return true;
        } else {
            return false;
        }
    }
}
