<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVwPedidosDelivery extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $nameView = "vw_pedidos_delivery";
        DB::statement($this->dropView($nameView));

        DB::statement("
            create view [dbo].[vw_pedidos_delivery] as
            select sum(i.vrTotal - i.desconto) as total,
            a.idAtendimento,
            a.idCliente,
            c.stCliente as cliente,
            a.idOperador,
            o.stApelido as operador,
            a.dtAbertura,
            a.dtConclusao,
            a.stStatus,
            a.flAtivo,
            a.flAgendarPedido,
            a.flOrcamento,
            case
                when a.engine is null then 'NATI'
                else a.engine
                end engine
            from dlv_Atendimentos as a
            inner join dlv_Itens i on a.idAtendimento = i.idAtendimento
            inner join dlv_Clientes c on a.idCliente = c.idCliente
            inner join op_Operadores o on a.idOperador = o.idOperador
            group by a.idAtendimento, a.idCliente, c.stCliente, a.idOperador, 	o.stApelido, a.dtAbertura, a.dtConclusao,  a.stStatus, a.flAtivo, a.flAgendarPedido, a.flOrcamento, a.engine, a.desconto

        ");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $nameView = 'vw_pedidos_delivery';
        DB::statement($this->dropView($nameView));
    }

    private function dropView($nameView)
    {
        return "if exists(select 1 from sys.views where name= '" . $nameView . "' and type='v')
                drop view " . $nameView . ";";
    }

}
