<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNatUpdateTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('nat_Update')) {

            DB::statement('CREATE TABLE [dbo].[nat_Update](
                  [idAtualizacao] [int] IDENTITY(1,1) NOT NULL,
                  [stAtualizacao] [nvarchar](50) NOT NULL,
                  [stStatus] [text] NOT NULL,
                  [dtData] [smalldatetime] NOT NULL,
                  [dtAlteracao] [datetime] NOT NULL,
                  CONSTRAINT [PK_nat_Update] PRIMARY KEY CLUSTERED
                    (
                      [idAtualizacao] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('nat_Update');

    }
}
