<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePrdLocalizacoesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('prd_Localizacoes')) {
            Schema::disableForeignKeyConstraints();
            DB::statement('CREATE TABLE [dbo].[prd_Localizacoes](
                  [idLocalizacao] [smallint] NOT NULL,
                  [stLocalizacao] [nvarchar](15) NOT NULL,
                  [flAtivo] [bit] NOT NULL CONSTRAINT [DF_prd_Localizacoes_flAtivo]  DEFAULT ((1)),
                  [dtAlteracao] [datetime] NOT NULL CONSTRAINT [DF_prd_Localizacoes_dtAlteracao]  DEFAULT (getdate()),
                  CONSTRAINT [PK_prd_Localizacoes] PRIMARY KEY CLUSTERED
                    (
                      [idLocalizacao] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
            Schema::enableForeignKeyConstraints();
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prd_Localizacoes');

    }
}
