<?php
ob_start();
date_default_timezone_set("Brazil/East");
require_once __DIR__ . '/../../vendor/autoload.php';
ini_set("memory_limit", "32M");
error_reporting(E_ALL ^ E_NOTICE);

require_once 'connection.php';

function permission($num)
{
    if (!autorization($num)) {
        redirect("logout.php");
        die;
    }
}

function redirect($url)
{
    echo("<script>document.location = '$url' </script>");
}

function logincheck()
{
    if (!isset($_COOKIE['idOperador']) || !isset($_COOKIE['stSenha'])) {
        $host = $_SERVER['HTTP_HOST'];
        die(header("Location: http://" . $host . "/logout"));
    }

    $sql_login = "SELECT * FROM op_Operadores WHERE idOperador = " . $_COOKIE['idOperador'] . " AND stSenha = '" . $_COOKIE['stSenha'] . "' AND flAtivo = '1'";
    $objResource = mssql_query($sql_login);
    if (mssql_num_rows($objResource) <= 0) {
        $host = $_SERVER['HTTP_HOST'];
        die(header("Location: http://" . $host . "/logout"));
    }
    $Op = mssql_fetch_object($objResource);

    if (!autorization(8)) {
        $host = $_SERVER['HTTP_HOST'];
        die(header("Location: http://" . $host . "/logout"));
    }

    if (
        substr($_SERVER['REMOTE_ADDR'], 0, 3) != "192" &&
        substr($_SERVER['REMOTE_ADDR'], 0, 3) != "127" &&
        $_SERVER['REMOTE_ADDR'] != "189.18.245.60" &&
        $_SERVER['REMOTE_ADDR'] != "200.171.113.106" &&
        $_SERVER['REMOTE_ADDR'] != '::1'
    ) {
//        if (!verifyKeyRemote()) {
//            logoutcookie();
//            die("Não foi detectada uma licença de uso para o acesso remoto, ou a licença atual não é mais válida. Favor entrar em contato com o suporte técnico.");
//        }

        if (!autorization(67)) :
            logoutcookie();
            die("Você não tem permissão para acessar o NATI atravàs da internet.");
        endif;
    }
}

function logoutcookie()
{
    $host = $_SERVER['HTTP_HOST'];
    die(header("Location: http://" . $host . "/logout"));
//    setcookie("idOperador", "", 0, "/");
//    setcookie("stSenha", "", 0, "/");
//    setcookie("laravel_session", "", 0, "/");
}

function validsec($sec)
{
    if ($sec == "")
        return "";

    $allowedchars = "abcdefghijklmnopqrstuvwxyz";

    for ($i = 0; $i < strlen($sec); ++$i)
        if (strpos($allowedchars, $sec[$i]) === false)
            return "";

    return $sec;
}

function autorization($section)
{
    $res = @mssql_query("SELECT TOP(1) idPermissao FROM op_Acessos WHERE idOperador = '" . $_COOKIE['idOperador'] . "' AND idPermissao = '$section'");
    $row = @mssql_fetch_row($res);

    if (!$row[0]) {
        return false;
    }
    return true;
}

function getElapsedTime($ts)
{
    if (strtotime(date("Y-m-d H:i:s")) > $ts) {
        $mins = floor((strtotime(date("Y-m-d H:i:s")) - $ts) / 60);

        $hours = floor($mins / 60);
        $mins -= $hours * 60;
        $days = floor($hours / 24);
        $hours -= $days * 24;
        $weeks = floor($days / 7);
        $days -= $weeks * 7;

        if ($weeks > 0)
            return "$weeks semana" . ($weeks > 1 ? "s" : "");
        if ($days > 0)
            return "$days dia" . ($days > 1 ? "s" : "");
        if ($hours > 0)
            return "$hours hora" . ($hours > 1 ? "s" : "");
        if ($mins > 0)
            return "$mins minuto" . ($mins > 1 ? "s" : "");
    }

    return "menos que 1 minuto";
}

function insertLog($stArea, $stDescricao, $idOperador = "")
{
    $stSoftware = "NATI";
    $idOperador = strlen($idOperador) > 0 ? $idOperador : $_COOKIE['idOperador'];

    $res = mssql_query("SELECT MAX(idLog) FROM nat_Log");
    $arr = mssql_fetch_array($res);

    $idLog = $arr[0] + 1;

    $res = mssql_query("SELECT stApelido FROM op_Operadores WHERE idOperador = '$idOperador'");
    $arr = mssql_fetch_array($res);

    $stOperador = $arr[0];

    mssql_query("INSERT INTO nat_Log (idLog, stOperador, dtData, stArea, stDescricao, stSoftware) VALUES ('$idLog', '$stOperador', GETDATE(), '$stArea', '$stDescricao', '$stSoftware')");
}

function graphycs($arr_values, $arr_itens, $graf_title, $graf_height = 300, $bar_width = 20, $bar_height = 250, $num_scales = 5)
{
    $max_value = 0;

    for ($x = 0; $x < count($arr_values); $x++) {
        for ($y = 0; $y < count($arr_values[$x]); $y++) {
            if ($max_value < $arr_values[$x][$y]) $max_value = $arr_values[$x][$y];
        }
    }

    echo "<table cellpadding='0' cellspacing='0' align='center'>
    <tr>
        <td></td>
        <td align='center'><font face='arial' size='3'><b>$graf_title</b></font></td>
    </tr>
    <tr>
        <td>
            <table cellpadding='0' cellspacing='2' width='100%' height='$graf_height'>";

    $y = $max_value;

    for ($x = 0; $x <= $num_scales; $x++) {
        echo "<tr>
                    <td><font face='arial' size='2'><b>" . intval($y) . "</b></font></td>
                </tr>";

        $y -= ($max_value / $num_scales);
    }

    echo "</table>
        </td>
        <td>
            <table cellpadding='0' cellspacing='3' width='100%' height='$graf_height'>
                <tr>";

    $c = 0;
    for ($x = 0; $x < count($arr_values); $x++) {
        if ($c == 0) {
            $c++;
            continue;
        }
        echo "<td valign='bottom'>
                        <table cellpadding='0' cellspacing='1' width='100%' height='100%'>
                           <tr>";

        for ($y = 0; $y < count($arr_values[$x]); $y++) {
            $length = ($bar_height * $arr_values[$x][$y]) / $max_value;

            echo "<td valign='bottom'>
                    <div align='center'>
                       <table cellpadding='0' cellspacing='0' width='$bar_width' height='$length' bgcolor='#FF0000'>
                            <tr>
                                <td></td>
                            </tr>
                        </table>
                    </div>
                </td>";
        }

        echo "</tr>
                </table>
            </td>";
    }

    echo "</tr>
        <tr>";

    $c = 0;
    foreach ($arr_itens as $x) {
        if ($c == 0) {
            $c++;
            continue;
        }
        echo "<td width='" . (($bar_width * count($arr_values[0])) + count($arr_values[0])) . "'><font face='arial' size='2'><b><div align='center'>$x</div></b></font></td>";
    }

    echo "</tr>
        </table>
    </td>
</tr>
</table>";
}

function getVersion()
{
    $fopen = fopen("../../VERSION.nati", "r");
    $fread = fread($fopen, filesize("../../VERSION.nati"));
    fclose($fopen);

    return $fread;
}

function verifyKey()
{
    $res = mssql_query("SELECT COUNT(*) FROM nat_Keys");
    $arr = mssql_fetch_array($res);

    if ($arr[0] == 0)
        return true;

    $res = mssql_query("SELECT * FROM Master");
    $arr = mssql_fetch_array($res);
    $idCliente = $arr['idCliente'];
    $idVendedor = $arr['idVendedor'];
    $stCliente = $arr['stCliente'];

    $res = mssql_query("SELECT * FROM nat_Keys WHERE stTipo = 'MN'");
    $arr = mssql_fetch_array($res);
    $stIndex = $arr['stIndex'];
    $stData = $arr['stData'];
    $stTipo = $arr['stTipo'];
    $stChave = $arr['stChave'];
    $stString = "ARCNET_AUTOMACAO_COMERCIAL";

    if (strlen($stChave) != 16)
        return false;

    $tmp = md5($stIndex . $stData . $stTipo . $stString . str_pad($idCliente, 6, "0", STR_PAD_LEFT) . str_pad($idVendedor, 3, "0", STR_PAD_LEFT) . $stCliente);
    $tmp = strtoupper(substr($tmp, 8, 16));

    if ($stChave != $tmp)
        return false;

    return true;
}

function verifyKeyRemote()
{
    $res = mssql_query("SELECT * FROM Master");
    $arr = mssql_fetch_array($res);
    $idCliente = $arr['idCliente'];
    $idVendedor = $arr['idVendedor'];
    $stCliente = $arr['stCliente'];

    $res = mssql_query("DECLARE @VAR NVARCHAR(3);
        SET @VAR = (SELECT MAX(stIndex) FROM nat_Keys WHERE stTipo = 'AR');
        SELECT * FROM nat_Keys WHERE stTipo = 'AR' AND stIndex = @VAR");
    $arr = mssql_fetch_array($res);

    $stIndex = $arr['stIndex'];
    $stData = $arr['stData'];
    $stTipo = $arr['stTipo'];
    $stChave = $arr['stChave'];
    $stString = "ARCNET_AUTOMACAO_COMERCIAL";

    if (date("Y", strtotime($stData)) != date("Y"))
        return false;

    if (strlen($stChave) != 16)
        return false;

    $tmp_full = md5($stIndex . $stData . $stTipo . $stString . str_pad($idCliente, 6, "0", STR_PAD_LEFT) . str_pad($idVendedor, 3, "0", STR_PAD_LEFT) . $stCliente);
    $tmp = strtoupper(substr($tmp_full, 8, 16));

    if ($stChave != $tmp)
        return false;

    return true;
}

function expandir($print)
{
    switch ($print) {
        case "BEMATECH_MP_2100TH":
            return chr(27) . "W1";
            break;
        case "EPSOM":
            return chr(27) . " " . chr(6) . chr(27) . "!" . chr(8);
            break;
        case "TANCA":
            return chr(27) . " " . chr(6) . chr(27) . "!" . chr(8);
            break;
        case "DIEBLO_IM423T":
            return chr(27) . "W" . chr(1);
            break;
        default:
            return chr(27) . chr(14);
            break;
    }
}

function comprimir($print)
{
    switch ($print) {
        case "BEMATECH_MP_2100TH":
            return chr(27) . "W0";
            break;

        case "EPSOM":
            return chr(27) . "!" . chr(1) . chr(27) . " " . chr(0);
            break;
        case "TANCA":
            return chr(27) . "!" . chr(1) . chr(27) . " " . chr(0);
            break;
        case "DIEBLO_IM423T":
            return chr(27) . "W" . chr(0);
            break;
        default:
            return chr(27) . "M";
            break;
    }
}

function rodape($print)
{
    switch ($print) {
        case "BEMATECH":
            return chr(27) . "w";
            break;

        case "EPSOM":
            return chr(10) . chr(10) . chr(10) . chr(10) . chr(10) . chr(27) . "i";
            break;
        case "TANCA":
            return chr(10) . chr(10) . chr(10) . chr(10) . chr(10) . chr(27) . "i";
            break;
        case "DARUMA":
            return chr(10) . chr(10) . chr(10) . chr(10) . chr(10) . chr(27) . "m";
            break;
        case "DIEBLO_IM423T":
            return chr(27) . "w";
            break;
        default:
            return chr(10) . chr(10) . chr(10) . chr(10) . chr(10) . chr(10) . chr(10) . chr(10) . chr(10);
            break;
    }
}

function codigoBarras($print, $nrCodigo)
{
    switch ($print) {
        case "BEMATECH":
            break;
        case "EPSOM":
            return chr(29) . "H" . chr(0) . chr(29) . "w" . chr(1) . chr(29) . "h" . chr(100) . chr(29) . "k" . chr(69) . chr(strlen($nrCodigo)) . $nrCodigo . chr(0);
            break;
        case "TANCA":
            return chr(29) . "H" . chr(0) . chr(29) . "w" . chr(1) . chr(29) . "h" . chr(100) . chr(29) . "k" . chr(69) . chr(strlen($nrCodigo)) . $nrCodigo . chr(0);
            break;
        case "DARUMA":
            return chr(27) . "b" . chr(5) . chr(2) . chr(100) . chr(0) . $nrCodigo . chr(0);
            break;
        case "DIEBLO_IM423T":
            break;
        default:
            break;
    }
}

function splitSentence($text, $maxPerLine)
{
    $text = explode(" ", $text);
    $count = 0;
    $ret1 = "";
    $ret2 = "";

    foreach ($text as $x) {
        $x = $x . " ";
        $count += strlen($x);

        if (strlen($ret1) > 0 && $count > $maxPerLine)
            $ret2 .= $x;
        else
            $ret1 .= $x;
    }

    return array($ret1, $ret2);
}

function NumberToExtenso($valor = 0, $monetario = true, $maiusculas = true, $feminino = false)
{
    $singular = array(($monetario ? "centavo" : ""), ($monetario ? "real" : ""), "mil", "milháo", "bilháo", "trilháo", "quatrilháo", "quintilháo");
    $plural = array(($monetario ? "centavos" : ""), ($monetario ? "reais" : ""), "mil", "milháes", "bilháes", "trilháes", "quatrilháes", "quintilháes");

    $c = array("", "cem", "duzentos", "trezentos", "quatrocentos", "quinhentos", "seiscentos", "setecentos", "oitocentos", "novecentos");
    $d = array("", "dez", "vinte", "trinta", "quarenta", "cinquenta", "sessenta", "setenta", "oitenta", "noventa");
    $d10 = array("dez", "onze", "doze", "treze", "quatorze", "quinze", "dezesseis", "dezesete", "dezoito", "dezenove");
    $u = array("", ($feminino ? "uma" : "um"), ($feminino ? "duas" : "dois"), "tràs", "quatro", "cinco", "seis", "sete", "oito", "nove");

    $z = 0;
    $rt = "";

    $valor = number_format($valor, 2, ".", ".");
    $inteiro = explode(".", $valor);

    for ($i = 0; $i < count($inteiro); $i++) {
        for ($ii = strlen($inteiro[$i]); $ii < 3; $ii++) {
            $inteiro[$i] = "0" . $inteiro[$i];
        }
    }

    $fim = count($inteiro) - ($inteiro[count($inteiro) - 1] > 0 ? 1 : 2);

    for ($i = 0; $i < count($inteiro); $i++) {
        $valor = $inteiro[$i];
        $rc = (($valor > 100) && ($valor < 200)) ? "cento" : $c[$valor[0]];
        $rd = ($valor[1] < 2) ? "" : $d[$valor[1]];
        $ru = ($valor > 0) ? (($valor[1] == 1) ? $d10[$valor[2]] : $u[$valor[2]]) : "";

        $r = $rc . (($rc && ($rd || $ru)) ? " e " : "") . $rd . (($rd && $ru) ? " e " : "") . $ru;
        $t = count($inteiro) - 1 - $i;
        $r .= $r ? " " . ($valor > 1 ? $plural[$t] : $singular[$t]) : "";

        if ($valor == "000")
            $z++;
        elseif ($z > 0)
            $z--;

        if (($t == 1) && ($z > 0) && ($inteiro[0] > 0))
            $r .= (($z > 1) ? " de " : "") . $plural[$t];

        if ($r)
            $rt = $rt . ((($i > 0) && ($i <= $fim) && ($inteiro[0] > 0) && ($z < 1)) ? (($i < $fim) ? ", " : ($monetario ? " e " : " virgula ")) : " ") . $r;
    }

    if (!$maiusculas)
        return ($rt ? $rt : "zero");
    else {
        if ($rt)
            $rt = str_replace(" E ", " e ", ucwords($rt));

        return ($rt ? $rt : "Zero");
    }
}

function getDadosRevenda()
{
    global $REVENDA_TELEFONE, $REVENDA_EMAIL, $REVENDA_NOME, $REVENDA_SITE, $REVENDA_TITULO_APLICATIVO;

    $REVENDA_TELEFONE = "[PABX] (11) 94748 - 5309";
    $REVENDA_EMAIL = "suporte@arcnet.com.br";
    $REVENDA_NOME = "Arcnet Desenvolvimento de Softwares LTDA";
    $REVENDA_SITE = "http://arcnet.com.br";
    $REVENDA_TITULO_APLICATIVO = "NATI < NÚCLEO ADMINISTRATIVO PARA TRATAMENTO DE INFORMAÇÔES > MÚDULO RETAGUARDA";
}

function updateDataBase()
{
    $qrySatVendas = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'sat_vendas' AND COLUMN_NAME LIKE 'SatEquipamento_Id'";
    $resSatVendas = mssql_query($qrySatVendas);
    $arrSatVendas = mssql_fetch_array($resSatVendas);
    if (!$arrSatVendas) {
        $qrySV = 'ALTER TABLE dbo.sat_vendas ADD
        [SatEquipamento_Id] [int] NULL';
        $res = mssql_query($qrySV);
    }

    $qryCest = "SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'cad_Cest'";
    $qry = mssql_query($qryCest);
    $res = mssql_fetch_array($qry);
    if ($res[0] == 0) {
        $qryC = "CREATE TABLE [dbo].[cad_Cest]
                ([nrNCM] [nvarchar](8) PRIMARY KEY,
                 [nrCEST] [nvarchar](7) NOT NULL)";
        mssql_query($qryC);

        $qryT = file_get_contents("qryCEST.txt");
        mssql_query($qryT);
    } else {
        $qryC = "DELETE FROM cad_Cest WHERE LEN(nrCEST) < 7";
        mssql_query($qryC);
    }

    $qryChk = "SELECT COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'op_Operadores' AND COLUMN_NAME LIKE 'idPerfil'";
    $resChk = mssql_query($qryChk);
    $arrChk = mssql_fetch_array($resChk);
    if (!$arrChk) {
        $qry = 'ALTER TABLE dbo.op_Operadores ADD
        idPerfil int NULL';
        $res = mssql_query($qry);
    }


    $qryCheck = "SELECT count(*) from INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'op_Perfis'";
    $resChk = mssql_query($qryCheck);
    $arrChk = mssql_fetch_array($resChk);
    if ($arrChk[0] == 0) {
        $qry = "CREATE TABLE [dbo].[op_Perfis](
        [idPerfil] [int] NOT NULL,
        [stDescricao] [nvarchar](50) NOT NULL,
        [stIds] [nvarchar](max) NOT NULL,
        CONSTRAINT [PK_op_Perfis] PRIMARY KEY CLUSTERED
        (
        [idPerfil] ASC
        )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
        ) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]";
        mssql_query($qry);
        $qry = "INSERT INTO op_Perfis (idPerfil, stDescricao, stIds) VALUES(1, 'MASTER', '[18,5,102,85,32,97,2,12,14,77,49,15,4,79,1,38,93,39,40,78,35,99,6,37,101,9,16,13,43,42,41,82,106,86,98,3,54,103,104,66,17,105,44,81,36,45,61,59,63,96,80,68,70,94,73,95,71,74,75,69,60,72,11,67,22,51,47,53,30,83,28,27,23,10,21,64,76,34,113,25,31,24,65,48,114,58,20,50,46,52,29,84,26,8,19,33,7,55,57,56,100]')";
        mssql_query($qry);
    }

    $qryChk = "SELECT COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'cx_TiposFormaPagamento' AND COLUMN_NAME LIKE 'flAtivo'";
    $resChk = mssql_query($qryChk);
    $arrChk = mssql_fetch_array($resChk);
    if (!$arrChk) {
        $qry = 'ALTER TABLE dbo.cx_TiposFormaPagamento ADD flAtivo bit NOT NULL CONSTRAINT DF_cx_TiposFormaPagamento_flAdquirente DEFAULT 1';
        $res = mssql_query($qry);
        $qry = "UPDATE cx_TiposFormaPagamento set flAtivo = 0 where stTipo not in ('CARTAO', 'CHEQUE', 'CHEQUEPRE', 'DINHEIRO', 'GETCONTRA', 'SETCONTRA', 'PENDURA_CR', 'SETPENDURA', 'TICKET', 'TICKETDG')";
        $res = mssql_query($qry);
        $qry = "UPDATE cx_TiposFormaPagamento set flAtivo = 1 where stTipo in ('CARTAO', 'CHEQUE', 'CHEQUEPRE', 'DINHEIRO', 'GETCONTRA', 'SETCONTRA', 'PENDURA_CR', 'SETPENDURA', 'TICKET', 'TICKETDG')";
        $res = mssql_query($qry);
    }

    $qryChk = "SELECT COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'op_Operadores' AND COLUMN_NAME LIKE 'stOBS'";
    $resChk = mssql_query($qryChk);
    $arrChk = mssql_fetch_array($resChk);
    if (!$arrChk) {
        $qry = 'ALTER TABLE op_Operadores ADD stOBS text';
        $res = mssql_query($qry);
    }


    $qryChk = "SELECT COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'nat_Modules' AND COLUMN_NAME LIKE 'main'";
    $resChk = mssql_query($qryChk);
    $arrChk = mssql_fetch_array($resChk);
    if (!$arrChk) {
        $qry = "ALTER TABLE dbo.nat_Modules ADD main nvarchar(200) NULL";
        $res = mssql_query($qry);
        $qry = "UPDATE nat_Modules set main = 'aWRDb21hbmRhO2ZhbHNlO2ZhbHNlO2lkQXRlbmRpbWVudG87ZmFsc2U='";
        $res = mssql_query($qry);
    }

    $qryCheck = "SELECT count(*) from INFORMATION_SCHEMA.TABLES
    WHERE TABLE_NAME = 'email'";
    $resChk = mssql_query($qryCheck);
    $arrChk = mssql_fetch_array($resChk);
    if ($arrChk[0] == 0) {
        $qry = "CREATE TABLE [dbo].[email](
        [id] [int] IDENTITY NOT NULL,
        [email] [nvarchar](75) NOT NULL,
        [senha] [nvarchar](35) NOT NULL,
        [servidor] [nvarchar](75) NOT NULL,
        [porta] [nvarchar](6) NOT NULL,
        [nome] [nvarchar](150) NOT NULL,
        [seguranca] [nvarchar](6) NOT NULL,
        [assunto] [nvarchar](500) NULL,
        [corpo] [nvarchar](500) NULL,
        [flLido] [bit] NOT NULL,
        CONSTRAINT [PK_email] PRIMARY KEY CLUSTERED
        (
        [email] ASC
        )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
        ) ON [PRIMARY]";
        $res = mssql_query($qry);
    }

    //UPDATE TABELAS FORMAS DE PAGAMENTO
    //Adição de flAdquirente em cx_FormasPagamento
    $qryChk = "SELECT COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'cx_FormasPagamento' AND COLUMN_NAME LIKE 'flAdquirente'";
    $resChk = mssql_query($qryChk);
    $arrChk = mssql_fetch_array($resChk);
    if (!$arrChk) {
        $qry = 'ALTER TABLE dbo.cx_FormasPagamento ADD flAdquirente bit NOT NULL CONSTRAINT DF_cx_FormasPagamento_flAdquirente DEFAULT 0';
        $res = mssql_query($qry);
    }

    //Adição de flCredito em fin_Bandeiras
    $qryChk = "SELECT COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'fin_Bandeiras' AND COLUMN_NAME LIKE 'flCredito'";
    $resChk = mssql_query($qryChk);
    $arrChk = mssql_fetch_array($resChk);
    if (!$arrChk) {
        $qry = 'ALTER TABLE dbo.fin_Bandeiras ADD flCredito smallint NOT NULL CONSTRAINT DF_fin_Bandeiras_flCredito DEFAULT 0';
        $res = mssql_query($qry);
    }


    $qryChk = "SELECT COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'fin_ContasBancarias' AND COLUMN_NAME LIKE 'stApelido'";
    $resChk = mssql_query($qryChk);
    $arrChk = mssql_fetch_array($resChk);
    if (!$arrChk) {
        $qry = "ALTER TABLE dbo.fin_ContasBancarias ADD
        stApelido nvarchar(20) NOT NULL CONSTRAINT DF_fin_ContasBancarias_stApelido DEFAULT ''";
        $res = mssql_query($qry);
    }
    //UPDATE DAS TABELAS DE ALIQUOTAS
    //alteração na tabela prd_Aliquotas
    $qryVerifiAliquota = "SELECT COUNT(*)
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'prd_Aliquotas'
    AND COLUMN_NAME LIKE 'Codigo'
    OR TABLE_NAME = 'prd_Aliquotas'
    AND COLUMN_NAME LIKE 'CstIcms'
    OR TABLE_NAME = 'prd_Aliquotas'
    AND COLUMN_NAME LIKE 'CstPis'
    OR TABLE_NAME = 'prd_Aliquotas'
    AND COLUMN_NAME LIKE 'CstCofins'
    OR TABLE_NAME = 'prd_Aliquotas'
    AND COLUMN_NAME LIKE 'CfopEntrada'
    OR TABLE_NAME = 'prd_Aliquotas'
    AND COLUMN_NAME LIKE 'CfopSaida'
    OR TABLE_NAME = 'prd_Aliquotas'
    AND COLUMN_NAME LIKE 'Iva'
    OR TABLE_NAME = 'prd_Aliquotas'
    AND COLUMN_NAME LIKE 'AliquotaIcms'
    OR TABLE_NAME = 'prd_Aliquotas'
    AND COLUMN_NAME LIKE 'AliquotaCofins'
    OR TABLE_NAME = 'prd_Aliquotas'
    AND COLUMN_NAME LIKE 'AliquotaPis'";
    $nrRows = mssql_fetch_array(mssql_query($qryVerifiAliquota))[0];

    if ($nrRows == 0) {
        $qryValoresPadrao = 'SELECT flSimplesNacional FROM master';
        $rsPadrao = mssql_fetch_assoc(mssql_query($qryValoresPadrao));
        $qryUpdateAliquota = "ALTER TABLE dbo.prd_Aliquotas ADD
        Codigo varchar(8) NULL,
        CstIcms varchar(3) NULL,
        CstPis varchar(2) NULL,
        CstCofins varchar(2) NULL,
        CfopEntrada varchar(4) NULL,
        CfopSaida varchar(4) NULL,
        Iva decimal(7, 4) NULL,
        AliquotaIcms decimal(7, 4) NULL,
        AliquotaCofins decimal(7, 4) NULL,
        AliquotaPis decimal(7, 4) NULL";
        mssql_query($qryUpdateAliquota);

        $qryUpdateStAliquota = "ALTER TABLE prd_Aliquotas
        ALTER COLUMN stAliquota nvarchar(8)";
        mssql_query($qryUpdateStAliquota);

        $qryUpdateValoresAliquotas = "SELECT * FROM prd_Aliquotas WHERE flAtivo = 1";
        $res = mssql_query($qryUpdateValoresAliquotas);
        while ($arr = mssql_fetch_assoc($res)) {
            if ($rsPadrao['flSimplesNacional'] == 0) {
                if ($arr['stAliquota'] == 'FF' || $arr['stAliquota'] == 'F') {
                    $qry = "UPDATE prd_Aliquotas SET Codigo = '5405-001' , CstIcms = '60' , CstPis = '01', CstCofins = '01', CfopEntrada = '1411', CfopSaida = '5405',
                    Iva = 0 , AliquotaIcms = " . $arr['vrAliquota'] . ", AliquotaCofins = 0, AliquotaPis = 0 WHERE idAliquota = " . $arr['idAliquota'];
                } else if ($arr['stAliquota'] == 'II' || $arr['stAliquota'] == 'I') {
                    $qry = "UPDATE prd_Aliquotas SET Codigo = '5102-006' , CstIcms = '40' , CstPis = '01', CstCofins = '01', CfopEntrada = '1202', CfopSaida = '5102',
                    Iva = 0 , AliquotaIcms = 0, AliquotaCofins = 0, AliquotaPis = 0 WHERE idAliquota = " . $arr['idAliquota'];
                } else {
                    $qry = "UPDATE prd_Aliquotas SET Codigo = '5102-010' , CstIcms = '00' , CstPis = '01', CstCofins = '01', CfopEntrada = '1202', CfopSaida = '5102',
                    Iva = 0 , AliquotaIcms = 0, AliquotaCofins = 0, AliquotaPis = 0  WHERE idAliquota = " . $arr['idAliquota'];
                }
            } else {
                if ($arr['stAliquota'] == 'FF' || $arr['stAliquota'] == 'F') {
                    $qry = "UPDATE prd_Aliquotas SET Codigo = '5405-001' , CstIcms = '500' , CstPis = '49', CstCofins = '49', CfopEntrada = '1411', CfopSaida = '5405',
                    Iva = 0 , AliquotaIcms = 0, AliquotaCofins = 0, AliquotaPis = 0 WHERE idAliquota = " . $arr['idAliquota'];
                } else if ($arr['stAliquota'] == 'II' || $arr['stAliquota'] == 'I') {
                    $qry = "UPDATE prd_Aliquotas SET Codigo = '5102-006' , CstIcms = '400' , CstPis = '49', CstCofins = '49', CfopEntrada = '1202', CfopSaida = '5102',
                    Iva = 0 , AliquotaIcms = 0, AliquotaCofins = 0, AliquotaPis = 0 WHERE idAliquota = " . $arr['idAliquota'];
                } else {
                    $qry = "UPDATE prd_Aliquotas SET Codigo = '5102-010' , CstIcms = '102' , CstPis = '49', CstCofins = '49', CfopEntrada = '1202', CfopSaida = '5102',
                    Iva = 0 , AliquotaIcms = 0, AliquotaCofins = 0, AliquotaPis = 0 WHERE idAliquota = " . $arr['idAliquota'];
                }
            }
            mssql_query($qry);
        }
    }

    //FIM DO UPDATE DAS TABELAS DE ALIQUOTAS

    //UPDATE DAS TABELAS DE PRODUTOS
    //Alteração no tamanho do campo de NCM
    $qryAddNcm = "SELECT count(COLUMN_NAME) from INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'prd_Produtos' AND COLUMN_NAME
    LIKE 'nrNcm'";
    $rs = mssql_query($qryAddNcm);
    $ArrRs = mssql_fetch_array($rs);
    if ($ArrRs[0] == '0') {
        $query = "ALTER TABLE prd_Produtos
        ADD [nrNcm]  varchar(7)";
        $rsq = mssql_query($query);
    }
    $qry = 'ALTER TABLE prd_Produtos
    ALTER COLUMN nrNCM varchar(8)';
    $res = mssql_query($qry);

    $qryAddCest = "SELECT count(COLUMN_NAME) from INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'prd_Produtos' AND COLUMN_NAME
    LIKE 'stCest'";
    $rs = mssql_query($qryAddCest);
    $ArrRs = mssql_fetch_array($rs);
    if ($ArrRs[0] == '0') {
        $query = "ALTER TABLE prd_Produtos
        ADD [stCest]  varchar(7)";
        $rsq = mssql_query($query);
    }

    $qryCheckType = "SELECT DATA_TYPE
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE
    TABLE_NAME = 'prd_Codigos' AND
    COLUMN_NAME = 'idCodigo'";
    $res = mssql_query($qryCheckType);
    $arr = mssql_fetch_assoc($res);
    if ($arr['DATA_TYPE'] != 'nvarchar') {
        //MUDANÇA DO CAMPO idCodigo para nvarchar(14)
        $qryIdCodigo = 'ALTER TABLE prd_Codigos
        DROP CONSTRAINT PK_prd_Codigos

        ALTER TABLE prd_Codigos
        ALTER COLUMN idCodigo nvarchar(14) NOT NULL

        ALTER TABLE dbo.prd_Codigos ADD CONSTRAINT
        PK_prd_Codigos PRIMARY KEY CLUSTERED (idCodigo)

        ALTER TABLE cx_Itens
        ALTER COLUMN idCodProduto nvarchar(14) NOT NULL

        ALTER TABLE cx_Itens_Temp
        ALTER COLUMN idCodProduto nvarchar(14) NOT NULL';
        mssql_query($qryIdCodigo);
    }


    //FIM DO UPDATE DAS TABELAS DE PRODUTOS

    //UPDATE TABELA DE ITENS LOG
    $qryUpdateIdLog = "SELECT DATA_TYPE
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE
    TABLE_NAME = 'mt_Itens_Log' AND
    COLUMN_NAME = 'idLog'";
    $idLogType = mssql_fetch_array(mssql_query($qryUpdateIdLog))[0];
    if ($idLogType != 'bigint') {
        $qry = "ALTER TABLE mt_Itens_Log
        DROP CONSTRAINT PK_mt_Itens_Log

        ALTER TABLE mt_Itens_Log
        ALTER COLUMN idLog bigint NOT NULL

        ALTER TABLE mt_Itens_Log
        ADD CONSTRAINT PK_mt_Itens_Log PRIMARY KEY (idLog)";
        mssql_query($qry);
    }
    //FIM UPDATE TABELA DE ITENS_LOG

    //UPDATE DAS TABELAS DE TESOURARIA(PRESIDENTE)
    //Adicionando permissao
    $sql_permissao = "IF NOT EXISTS (SELECT TOP(1) * FROM op_Permissoes WHERE idPermissao = 113)
    INSERT INTO op_Permissoes VALUES (113, 'Deletar Fechamento de Caixa', 1, 'Deletar o fechamento de caixa na tela do presidente', GETDATE());";
    mssql_query($sql_permissao);

    //UPDATE DAS TABELAS DE TESOURARIA(PRESIDENTE)
    //Adicionando permissao
    $sql_permissao = "IF NOT EXISTS (SELECT TOP(1) * FROM op_Permissoes WHERE idPermissao = 115)
    INSERT INTO op_Permissoes VALUES (115, 'Baixar Pedidos do Delivery', 1, 'Baixar Pedidos do Delivery. (Ctrl + D.)', GETDATE());";
    mssql_query($sql_permissao);

    //Atualizando tabela com Order e ParentId
    $queryAtualizaOrdem = "SELECT COLUMN_NAME from INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'cx_FormasPagamento' AND COLUMN_NAME
    LIKE 'ORDER' OR COLUMN_NAME LIKE 'parentId'";
    $rs = mssql_query($queryAtualizaOrdem);
    $ArrRs = mssql_fetch_array($rs);
    if (count($ArrRs) < 2) {
        $query1 = "ALTER TABLE cx_FormasPagamento
        ADD [order]  int NOT NULL   default 0";
        $rsq1 = mssql_query($query1);
        $query2 = "ALTER TABLE cx_FormasPagamento
        ADD [parentId]  varchar(3) NOT NULL default 0";
        $rsq2 = mssql_query($query2);
    }

    //Adição do campo pagamentoSat na tabela de cx_FormasPagamento
    $qryAddSat = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'cx_FormasPagamento' AND COLUMN_NAME LIKE 'pagamentoSat'";
    $resSat = mssql_query($qryAddSat);
    $arrSat = mssql_fetch_array($resSat);
    if (!$arrSat) {
        $qrySat = "ALTER TABLE cx_FormasPagamento ADD [pagamentoSat] int NOT NULL default 1";
        $rsSat = mssql_query($qrySat);
    }

    //Criação da tabela cx_HistoricoFechamento
    $queryAtualizaSalvaHistFechamento = "SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'cx_HistoricoFechamento'";
    $rs2 = mssql_query($queryAtualizaSalvaHistFechamento);
    $ArrRs2 = mssql_fetch_array($rs2);

    if ($ArrRs2 === false) {
        $scriptHisFechamento = "CREATE TABLE [dbo].[cx_HistoricoFechamento](
        [id] [int] IDENTITY(1,1) NOT NULL,
        [idAbertura] [int] NOT NULL,
        [vrApurado] [decimal](18, 2) NOT NULL,
        [vrFechamento] [decimal](18, 2) NOT NULL,
        [vrDiferenca] [decimal](18, 2) NOT NULL,
        [dtData] [datetime] NOT NULL,
        [dtAlteracao] [datetime] NOT NULL,
        CONSTRAINT [PK_cx_historicoFechamento] PRIMARY KEY CLUSTERED
        (
        [id] ASC
        )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
        ) ON [PRIMARY]";
        $rsx = mssql_query($scriptHisFechamento) or $trans = false;
        mssql_query("EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'apurado pelo operador no fechamento de caixa' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'cx_historicoFechamento', @level2type=N'COLUMN',@level2name=N'vrApurado'");
        mssql_query("EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'valor que o sistema computou até o fechamento' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'cx_historicoFechamento', @level2type=N'COLUMN',@level2name=N'vrFechamento'");
        mssql_query("EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'diferenca entre o valor apurado pelo operador e o sistema' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'cx_historicoFechamento', @level2type=N'COLUMN',@level2name=N'vrDiferenca'");
        mssql_query("EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'cx_historicoFechamento'");
    }



    //Verifica Permissão para excluir movimento
    $qryPermissoes = "select * from op_permissoes where idPermissao = 114";
    $rs = mssql_fetch_array(mssql_query($qryPermissoes));
    if ($rs === false) {
        $nvPermissao = "insert into op_permissoes (idPermissao,stPermissao,idCategoria,stDescricao,dtAlteracao) "
            . "values (114,'Limpa Movimento',1,'Remover a movimentacao de um periodo da base de dados',getdate())";
        $rs2 = mssql_query($nvPermissao);
    }
}

// Out all especial characters
function sanitizeString($string)
{

    // matriz de entrada
    $what = array('ä', 'ã', 'à', 'á', 'â', 'ê', 'ë', 'è', 'é', 'ï', 'ì', 'í', 'ö', 'õ', 'ò', 'ó', 'ô', 'ü', 'ù', 'ú', 'û', 'À', 'Á', 'Ã', 'Â', 'Ô', 'Õ', 'É', 'Í', 'Ó', 'Ú', 'ñ', 'Ñ', 'ç', 'Ç', '-', '(', ')', ',', ';', ':', '|', '!', '"', '#', '$', '%', '&', '/', '=', '?', '~', '^', '>', '<', 'ª', 'º', '@', '*', '¨', '{', '}', '[', ']', '´', '`', '.', '_', '+', '&');

    // matriz de saída
    $by = array('a', 'a', 'a', 'a', 'a', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'A', 'A', 'A', 'A', 'O', 'O', 'E', 'I', 'O', 'U', 'n', 'n', 'c', 'C', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');

    // devolver a string
    return str_replace($what, $by, $string);
}

// Allow / ( )
function sanitizeString2($string)
{

    // matriz de entrada
    $what = array('ä', 'ã', 'à', 'á', 'â', 'ê', 'ë', 'è', 'é', 'ï', 'ì', 'í', 'ö', 'õ', 'ò', 'ó', 'ô', 'ü', 'ù', 'ú', 'û', 'À', 'Á', 'Ã', 'Â', 'Ô', 'Õ', 'É', 'Í', 'Ó', 'Ú', 'ñ', 'Ñ', 'ç', 'Ç', '-', ',', ';', ':', '|', '!', '"', '#', '$', '%', '&', '=', '?', '~', '^', '>', '<', 'ª', 'º', '@', '*', '¨', '{', '}', '[', ']', '´', '`', '.', '_', '+', '&');

    // matriz de saída
    $by = array('a', 'a', 'a', 'a', 'a', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'A', 'A', 'A', 'A', 'O', 'O', 'E', 'I', 'O', 'U', 'n', 'n', 'c', 'C', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');

    // devolver a string
    return str_replace($what, $by, $string);
}

// Allow / ( ) : ; - .
function sanitizeString4($string)
{

    // matriz de entrada
    $what = array('ä', 'ã', 'à', 'á', 'â', 'ê', 'ë', 'è', 'é', 'ï', 'ì', 'í', 'ö', 'õ', 'ò', 'ó', 'ô', 'ü', 'ù', 'ú', 'û', 'À', 'Á', 'Ã', 'Â', 'Ô', 'Õ', 'É', 'Í', 'Ó', 'Ú', 'ñ', 'Ñ', 'ç', 'Ç', ',', '|', '!', '"', '#', '$', '%', '&', '=', '?', '~', '^', '>', '<', 'ª', 'º', '@', '*', '¨', '{', '}', '[', ']', '´', '`', '_', '+', '&');

    // matriz de saída
    $by = array('a', 'a', 'a', 'a', 'a', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'A', 'A', 'A', 'A', 'O', 'O', 'E', 'I', 'O', 'U', 'n', 'n', 'c', 'C', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');

    // devolver a string
    return str_replace($what, $by, $string);
}


function retornaJson($status, $message, $location = "", $time = 0)
{

    $response_array['status'] = $status;
    $response_array['msg'] = $message;

    if ($status) {
        $response_array['location'] = $location;
        $response_array['time'] = $time;
    }

    return json_encode($response_array);
}


function sqlDate($initData, $endDate)
{
    $de = explode('/', $initData);
    $data['dataInicial'] = $de[2] . '-' . $de[1] . '-' . $de[0] . ' 00:00:00';
    $ate = explode('/', $endDate);
    $data['dataFinal'] = $ate[2] . '-' . $ate[1] . '-' . $ate[0] . ' 23:59:59';

    return $data;
}
