var categorias = [];

document.addEventListener("DOMContentLoaded", function () {
    $('#modalCategoria').on('hidden.bs.modal', function () {
        $("#stCategoria").val('');
    });
    $('#modalSubCategoria').on('hidden.bs.modal', function () {
        $("#bodyListagemSubCategoria").html('');
        $("#modalSubCategoriaTitle").html('');
    });
    $('#modalNovaSubCategoria').on('hidden.bs.modal', function () {
        $("#modalNovaSubCategoriaTitle").html('');
        $("#stSubCategoria").val('');
    });
    $('#modalTransferCategoria').on('hidden.bs.modal', function () {
        $("#selectTranferCategoria").val('0');
        $("#selectTranferSubCategoria").val('0');
    });
    $('#modalCategoriaItem').on('hidden.bs.modal', function () {
        $('#idCategoriaItemAdicional').val('');
        $('#stCategoriaItem').val('')
        $("#divStCategoriaItem").removeClass('has-error');
    });

    var pagina = $("#idPagina").val();
    if (pagina == "itemAdicional") {
        var data = {action: 'getCategoriasItens'};
        $.post('produtos/resources/php/categorias_functions.php', data, function (dados) {
            var linha = '';
            if(dados) {
                for (var i = 0; i < dados.length; i++) {
                    linha += '<tr><td class="tdStyle" id="st' + dados[i].idCategoriaItemAdicional + '">' + dados[i].stCategoriaItemAdicional + '</td>';
                    linha += '<td class="tdStyle">';
                    linha += '<a onclick="editCategoriaItem(' + dados[i].idCategoriaItemAdicional + ')" style="cursor:pointer"><span style="font-size:15px" class="glyphicon glyphicon-edit col-md-6" align="center" title="Editar"></span></a>';
                    linha += '<a onclick="excluirCategoriaItem(' + dados[i].idCategoriaItemAdicional + ')" style="cursor:pointer"><span style="font-size:15px" class="glyphicon glyphicon-remove col-md-6" align="center" title="Remover"></span></a>';
                    linha += '</td></tr>';
                }
                $(linha).appendTo($("#bodyTabelaCategoriasItens"));
            }
        });
    } else if (pagina == "subCategorias") {
        var data = {action: 'getSubCategorias'};
        $.post('produtos/resources/php/categorias_functions.php', data, function (response) {
            var idCategoria = response[0].idCategoria;
            var linha = '';
            for (var i = 0; i < response.length; i++) {
                if (i != 0 && idCategoria != response[i].idCategoria) {
                    linha += '</tbody>';
                    linha += '</table>';
                    linha += '</div>';
                    linha += '</div>';
                    linha += '</div>';
                }
                if (i === 0 || idCategoria !== response[i].idCategoria) {
                    var idCategoria = response[i].idCategoria;
                    linha += '<div class="panel panel-default"><a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion" href="#collapse' + response[i].idCategoria + '" aria-expanded="false" aria-controls="collapse' + response[i].idCategoria + '">';
                    linha += '<div class="panel-heading" role="tab" id="heading' + response[i].idCategoria + '"><h4 class="panel-title">' + response[i].stCategoria + '</h4></div></a>';
                    linha += '<div id="collapse' + response[i].idCategoria + '" class="panel-collapse collapse" role="tabpanel"><div class="panel-body">';
                    linha += '<div class="col-md-4 col-md-offset-4" align="center"><button type="button" class="btn btn-nati" onclick="addSubCategoria(' + response[i].idCategoria + ')">Nova Sub-Categoria</button></div>'
                    linha += '<table class="table table-striped table-borded tabelaBordaSimples" id="tableSubCategorias"><thead><th width="80%">Sub-Categoria</th><th width="20%">Ação</th></thead><tbody id="bodyListagemSubCategoria">';
                }
                linha += '<tr><td class="tdStyle" id="' + response[i].idCategoria + '' + response[i].idSubCategoria + '">' + response[i].stSubCategoria + '</td>';
                linha += '<td class="tdStyle">';
                linha += '<a style="cursor:pointer" onclick="editSubCategoria(' + response[i].idCategoria + ', ' + response[i].idSubCategoria + ')"><span style="font-size:15px" class="glyphicon glyphicon-edit col-md-6" align="center" title="Editar"></span></a>';
                linha += '<a style="cursor:pointer" onclick="deleteSubCategoria(' + response[i].idCategoria + ', ' + response[i].idSubCategoria + ')"><span style="font-size:15px" class="glyphicon glyphicon-remove col-md-6" align="center" title="Remover"></span></a>';
                linha += '</td></tr>';
            }
            $(linha).appendTo($("#accordion"));
        });
    } else if (pagina == 'categorias') {
        var data = {action: 'getCategorias'};
        $.post('produtos/resources/php/categorias_functions.php', data, function (response) {
            var linha = '';
            for (var i = 0; i < response.length; i++) {
                linha += '<tr><td class="tdStyle" id="st' + response[i].idCategoria + '"><a href="#" class="alert-link" onclick="getSubCategoria(' + response[i].idCategoria + ')">' + response[i].stCategoria + '</a></td>';
                linha += '<td class="tdStyle">' + response[i].nrProdutos + '</td>';
                linha += '<td class="tdStyle">';
                linha += '<a style="cursor:pointer" onclick="editCategoria(' + response[i].idCategoria + ')"><span style="font-size:15px" class="glyphicon glyphicon-edit col-md-6" align="center" title="Editar"></span></a>';
                linha += '<a style="cursor:pointer" onclick="askExcluirCategoria(' + response[i].idCategoria + ')"><span style="font-size:15px" class="glyphicon glyphicon-remove col-md-6" align="center" title="Remover"></span></a>';
                linha += '</td></tr>';
            }
            $(linha).appendTo($("#bodyTabelaCategoriasItems"));
            initializeDataTables("listagem_categorias");
        });
    }
});

// Categoria
function novaCategoria() {
    $("#modalCategoriaTitle").html('Cadastro de Categoria');
    $("#modalCategoria").modal('show');
}

function salvarCategoria() {
    toastr.options =
        {
            "positionClass": "toast-bottom-right"
        }

    var idCategoria = $("#idCategoria").val();
    var stCategoria = $("#stCategoria").val();

    if (stCategoria.length === 0) {
        toastr.error('Digite um nome para a Categoria!');
        $("#divStCategoria").addClass('has-error');
        return false;
    }

    var action = 'cadastrarCategoria';

    if (idCategoria) {
        action = 'editarCategoria';
        var data = {action: action, idCategoria: idCategoria, stCategoria: stCategoria};
        $.post('produtos/resources/php/categorias_functions.php', data, function (response) {
            if (response.status) {
                toastr.success(response.msg);
                setTimeout(function () {
                    location.reload();
                }, 1000);
            }
            else {
                toastr.error(response.msg);
            }
        });
    }
    else {
        var data = {action: action, stCategoria:stCategoria};
        $.post('produtos/resources/php/categorias_functions.php', data)
            .success(function (response) {
                toastr.success(response.message);
                setTimeout(function () {
                    location.reload();
                }, 1000);
            })
            .error(function (response) {
                toastr.error(response.message);
            });
    }
}

function cleanModal() {
    $("#modalCategoriaTitle").html('');
    var idCategoria = $("#idCategoria").val();
    var stCategoria = $("#stCategoria").val();
}

function editCategoria(idCategoria) {
    console.log('editCategoria("' + idCategoria + '")');

    cleanModal();
    toastr.options =
        {
            "positionClass": "toast-bottom-right"
        };

    $.get('/api/nati/v1/categorias/' + idCategoria)
        .success(function (response) {
            console.log('categoria response', response)
            var data = response['data'];
            $("#modalCategoriaTitle").html('Edição da Categoria ' + response.stCategoria);
            $("#stCategoria").val(response.stCategoria);
            $("#idCategoria").val(response.idCategoria);
        })
        .done(function () {
            $("#modalCategoria").modal('show');
        })
        .error(function (response) {
            toastr.error(response.msg);
        });
}

function askExcluirCategoria(idCategoria) {

    toastr.options =
        {
            "positionClass": "toast-bottom-right"
        };
    swal({
            title: 'Tem certeza?',
            text: 'Tem certeza que deseja excluir esta Categoria ??',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#2A98D3',
            cancelButtonColor: '#FF2727',
            confirmButtonText: 'Continuar',
            cancelButtonText: 'Cancelar',
            closeOnConfirm: true
        }, function () {
            $.delete('/api/nati/v1/categorias/'+ idCategoria)
                .success(function (response) {
                    console.log('success', response);
                    toastr.success(response.message);
                    setTimeout(function () {
                        location.reload();
                    }, 1000);
                })
                .error(function (response) {
                    toastr.error("Ocorreu um erro ao tentar Excluir a Categoria!");
                });
        }
    );
}

// Sub-Categoria
function getSubCategoria(categoria) {
    var data = {
        action: 'getSubCategorias',
        categoria: categoria
    };
    $.post('produtos/resources/php/categorias_functions.php', data, function (response) {
        var stCat = response[0].stCategoria['stCategoria'];
        $("#modalSubCategoriaTitle").html('Categoria ' + stCat + '');

        var idCat = response[0].idCategoria;
        $("#idCategoria").val(idCat);

        var linha = '';
        if (response.length === 1) {
            linha += '<tr><td class="tdStyle">Não Possui Sub-Categoria</td><td></td></tr>';
            $(linha).appendTo($("#bodyListagemSubCategoria"));
            $("#modalSubCategoriaTitle").html('Categoria ' + stCat + '');
            $("#modalSubCategoria").modal('show');
            return;
        }
        response.splice(0, 1);
        for (var i = 0; i < response.length; i++) {
            linha += '<tr id="linhaBody"><td class="tdStyle" id="' + response[i].idCategoria + '' + response[i].idSubCategoria + '">' + response[i].stSubCategoria + '</td>';
            linha += '<td class="tdStyle">';
            linha += '<a style="cursor:pointer" onclick="editSubCategoria(' + response[i].idCategoria + ', ' + response[i].idSubCategoria + ')"><span style="font-size:15px" class="glyphicon glyphicon-edit col-md-6" align="center" title="Editar"></span></a>';
            linha += '<a style="cursor:pointer" onclick="deleteSubCategoria(' + response[i].idCategoria + ', ' + response[i].idSubCategoria + ')"><span style="font-size:15px" class="glyphicon glyphicon-remove col-md-6" align="center" title="Remover"></span></a>';
            linha += '</td></tr>';
            $('#selectTransferSubCategoria').append($("<option></option>").attr("value", response[i].idSubCategoria).text(response[i].stSubCategoria));
        }
        $(linha).appendTo($("#bodyListagemSubCategoria"));
    });
    $("#modalSubCategoria").modal('show');
}

function addSubCategoria(idCategoria) {
    var idCat = idCategoria.idCategoria.value;
    $("#modalNovaSubCategoriaTitle").html('Cadastro de Sub-Categoria');
    $("#stSubCategoria").val('');
    $("#idCategoria").val(idCat);

    $("#modalNovaSubCategoria").modal('show');
}

function cadastrarSubCategoria() {
    toastr.options =
        {
            "positionClass": "toast-bottom-right"
        }

    var Categoria = $("#idCategoria").val();
    var idSub = $("#idSubCategoria").val();
    var subCategoria = $("#stSubCategoria").val();

    if (subCategoria.length == 0) {
        toastr.error('Digite um nome para a Categoria!');
        $("#divStCategoria").addClass('has-error');
        return false;
    }
    else {
        action = 'cadastrarSubCategoria';
        var data = {
            action: action,
            subCategoria: subCategoria,
            Categoria: Categoria,
            idSub: idSub
        };
    }

    $.post('produtos/resources/php/categorias_functions.php', data, function (response) {
        if (response.status) {
            toastr.success(response.msg);
            setTimeout(function () {
                location.reload();
            }, 1000);
        }
        else {
            toastr.error(response.msg);
        }
    });
}

function editSubCategoria(idCategoria, idSubCategoria) {
    var data = {
        action: 'editarSubCategoria',
        idCategoria: idCategoria,
        idSubCategoria: idSubCategoria
    };
    $.post('produtos/resources/php/categorias_functions.php', data, function (response) {
        var idCat = response[0].idCategoria;
        var idSub = response[0].idSubCategoria;
        var stSubCat = response[0].stSubCategoria;
        $("#modalNovaSubCategoriaTitle").html('Editar Sub-Categoria ' + stSubCat + '');
        $("#stSubCategoria").val(stSubCat);
        $("#idSubCategoria").val(idSub);
    });
    $("#modalNovaSubCategoria").modal('show');
}

function deleteSubCategoria(idCategoria, idSubCategoria) {
    var data = {action: 'getCategorias'};
    $.post('produtos/resources/php/categorias_functions.php', data, function (response) {
        for (var i = 0; i < response.length; i++) {
            $('#selectTranferCategoria').append($("<option></option>").attr("value", response[i].idCategoria).text(response[i].stCategoria));
        }
    });

    var data2 = {
        action: 'getSubCategorias',
        categoria: idCategoria
    };
    $.post('produtos/resources/php/categorias_functions.php', data2, function (response) {
        for (var i = 0; i < response.length; i++) {
            $('#selectTranferSubCategoria').append($("<option id='idCategoria'></option>").attr("value", response[i].idSubCategoria).text(response[i].stSubCategoria));
        }
    });
    $("#idCategoriaOld").val(idCategoria);
    $("#idSubCategoriaOld").val(idSubCategoria);
    $("#modalTransferCategoria").modal('show');
}

function trocaSub() {
    $("#selectTranferSubCategoria").html('');
    idCategoria = $('#selectTranferCategoria').val();
    var data3 = {
        action: 'getSubCategorias',
        categoria: idCategoria
    };
    $.post('produtos/resources/php/categorias_functions.php', data3, function (response) {
        $('#selectTranferSubCategoria').empty();
        for (var i = 0; i < response.length; i++) {
            $('#selectTranferSubCategoria').append($("<option id='idSubCategoria'></option>").attr("value", response[i].idSubCategoria).text(response[i].stSubCategoria));
        }
    });
}

function askTransferSub(idCategoria, idSubCategoria, idCategoriaOld, idSubCategoriaOld) {

    toastr.options =
        {
            "positionClass": "toast-bottom-right"
        }

    swal({
            title: 'Tem certeza ??',
            text: 'Tem certeza que deseja mover os itens desta Sub-Categoria ??',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#2A98D3',
            cancelButtonColor: '#FF2727',
            confirmButtonText: 'Continuar',
            cancelButtonText: 'Cancelar',
            closeOnConfirm: true
        },
        function () {
            var data = {
                action: 'transferSub',
                idCategoria: idCategoria,
                idSubCategoria: idSubCategoria[2].value,
                idCategoriaOld: idCategoriaOld,
                idSubCategoriaOld: idSubCategoriaOld
            }
            $.post('produtos/resources/php/categorias_functions.php', data, function (response) {
                if (response.status) {
                    toastr.success(response.msg);
                    setTimeout(function () {
                        location.reload();
                    }, 1000);
                }
                else {
                    toastr.error(response.msg);
                }
            });
        });
}

function initializeDataTables(name) {
    $('#' + name).DataTable({
        "language": {
            "url": "produtos/resources/js/Portuguese-Brasil.json"
        }
    });

}

// CATEGORIA ITEM ADICIONAL

function novaCategoriaItem() {
    $("#modalCategoriaItemTitle").html('Cadastro de Categoria Item Adicional');
    $("#modalCategoriaItem").modal('show')
}

function cadastrarCategoriaItem() {

    toastr.options =
        {
            "positionClass": "toast-bottom-right"
        }

    var idCategoriaItemAdicional = $("#idCategoriaItemAdicional").val();
    var stCategoriaItemAdicional = $("#stCategoriaItem").val();

    if (stCategoriaItemAdicional.length === 0) {
        toastr.error('Digite um nome para a categoria adicional');
        $("#divStCategoriaItem").addClass('has-error');
        return false;
    }

    var action = 'cadastrarCategoriaItem';

    if (idCategoriaItemAdicional) {
        action = 'updateCategoriaItem';
        var data = {action: action, idCategoriaItemAdicional: idCategoriaItemAdicional, stCategoriaItemAdicional: stCategoriaItemAdicional};
        $.post('produtos/resources/php/categorias_functions.php', data, function (response) {
            if (response.status) {
                toastr.success(response.msg);
                setTimeout(function () {
                    location.reload();
                }, 1000);
            }
            else {
                toastr.error(response.msg);
                $("#divStCategoriaItem").addClass('has-error');
            }
        });
    }
    else {
        action = 'cadastrarCategoriaItem';
        var data = {action: action, stCategoriaItemAdicional: stCategoriaItemAdicional};

        $.post('produtos/resources/php/categorias_functions.php', data)
            .success(function (response) {
                toastr.success(response.msg);
                setTimeout(function () {
                    location.reload();
                }, 1000);
            })
            .error(function (response) {
                toastr.error(response.msg);
            });
    }

}

function editCategoriaItem(idCategoriaItemAdicional) {
    var data = {
        action: 'editarCategoriaItem',
        idCategoriaItemAdicional: idCategoriaItemAdicional,
    };

    $.post('produtos/resources/php/categorias_functions.php', data, function (response) {

        var idCatItem = response.idCategoriaItemAdicional;
        var stCatItem = response.stCategoriaItemAdicional;
        $('#idCategoriaItemAdicional').val(idCatItem);
        $('#stCategoriaItem').val(stCatItem)

    });


    $("#modalCategoriaItemTitle").html('Editar Categoria Item Adicional');
    $("#modalCategoriaItem").modal('show')

}

function excluirCategoriaItem(idCategoriaItemAdicional) {
    toastr.options =
        {
            "positionClass": "toast-bottom-right"
        };
    swal({
            title: 'Tem certeza?',
            text: 'Tem certeza que deseja excluir esta Categoria ??',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#2A98D3',
            cancelButtonColor: '#FF2727',
            confirmButtonText: 'Continuar',
            cancelButtonText: 'Cancelar',
            closeOnConfirm: true
        }, function () {

            action = 'excluirCategoriaItem';
            var data = {action: action, idCategoriaItemAdicional: idCategoriaItemAdicional};

            $.post('produtos/resources/php/categorias_functions.php', data)
                .success(function (response) {
                    toastr.success(response.msg);
                    setTimeout(function () {
                        location.reload();
                    }, 1000);
                })
                .error(function (response) {
                    toastr.error(response.msg);
                });
        }
    );
}

