document.addEventListener("DOMContentLoaded", function() {
	getCodigos();

});

function getCodigos() {
	$.post('produtos/resources/php/codigos_functions.php', {action: 'getCodigos'}, function (response) {
		var linha = '';
		if (!response) {
			linha = '<tr><td colspan="8" align="center">NENHUM CÓDIGO ERRADO</td></tr>';
			$(linha).appendTo($("#bodyListagem"));
			return false;
		}
		for (var i = 0; i < response.length; i++) {
			linha += '<tr>';
			linha += '<td>'+response[i]['idCodigo']+'</td>';
			linha += '<td>'+response[i]['stProduto']+'</td>';
			linha += '<td><input id="codigo'+response[i]['idCodigo']+'" class="form-control input-sm" type="text" maxlength="20" value="'+response[i]['idCodigo']+'"></td>';
			linha += '</tr>';
		}
		$(linha).appendTo($("#bodyListagem"));
	});
}

function salvar(){
	toastr.options = {"positionClass": "toast-bottom-right"};
	var action = 'salvar';
	var codigos = [];
	var oldCodigo = '';
	var newCodigo = '';
	$('input[id^="codigo"]').each(function(){
		oldCodigo = $(this).attr('id');
		oldCodigo = oldCodigo.replace('codigo', '');
		newCodigo = $(this).val();
		codigos.push({oldCodigo, newCodigo});
	});
	codigos = JSON.stringify(codigos);
	var data = {
		action: action, 
		codigos: codigos
	};

	$.post('produtos/resources/php/codigos_functions.php', data, function (response) {
		if(response.status){
			toastr.success(response.msg);
			setTimeout(function(){location.reload();},1000);
		}else{
			toastr.error(response.msg);
		} 
	});
}

