<?php

namespace App\Entities\Nati;

use App\Traits\HasCompositePrimaryKey;
use Database\Factories\CodeFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Code extends Model implements Transformable
{
    //    use HasCompositePrimaryKey;
    use TransformableTrait, HasFactory;

    protected $table = 'prd_Codigos';
    protected $primaryKey = ['idCodigo', 'idProduto'];
    public $incrementing = false;
    public $timestamps = false;

    protected $fillable = [
        'idCodigo',
        'idProduto',
        'dtAlteracao',
        'flPrincipal',
        'vrMultiplo'
    ];
    /**
     * Create a new factory instance for the model.
     *
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    protected static function newFactory()
    {
        return CodeFactory::new();
    }
    public function produto()
    {
        return $this->belongsTo(Product::class, 'idProduto');
    }


    //composite key
    public function getKey()
    {
        return $this->idCodigo;
    }
}
