<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Impressora extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = "mt_Prints";
    protected $primaryKey = "idPrint";
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idPrint',
        'stPrint',
        'stLocalPrint',
        'stCanal',
        'stModelo',
        'flAgruparItens',
        'dtAlteracao',
        'nrAvancos',
        'nrColunas'
    ];

    protected $casts = [
        'flAgruparItens' => 'boolean',
    ];
}
