<?php

namespace App\Entities\Nati;

use App\Entities\ProductComposite;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Database\Factories\ProductFactory;

/**
 * Class Product
 * @package Modules\Products\Entities
 */
class Product extends Model implements Transformable
{
    use TransformableTrait, HasFactory;

    protected $table = 'prd_Produtos';
    protected $primaryKey = 'idProduto';

    public $timestamps = false;
    public $incrementing = false;

    protected $casts = [
        'flComissao' => 'boolean',
        'flAtivo' => 'boolean',
        'flControlarEstoque' => 'boolean',
        'flPocket' => 'boolean',
        'flPromocao' => 'boolean',
        'flPromocaoLevePague' => 'boolean',
        'flVendaCartao' => 'boolean',
        'flVendaTicket' => 'boolean',
        'flVendaSmart' => 'boolean',
        'flRequererItemAdicional' => 'boolean',
        'flBalanca' => 'boolean',
        'flCupomPreVenda' => 'boolean',
        'flDesconto' => 'boolean',
        'flPromocaoHora' => 'boolean',
        'vrUnitario' => 'float',
        'vrUnitario2' => 'float',
        'vrCusto' => 'float',
        'vrUnitarioPromocao' => 'float',
        'vrUnitarioPromocaoHora' => 'float',
        'vrMargemLucro' => 'float',
        'flRevisaoTributaria' => 'boolean',
        'idProduto' => 'integer',
        'idCategoria' => 'integer',
        'idSubCategoria' => 'integer',
        'idSetor' => 'integer',
        'idMedida' => 'integer',
        'idLocalizacao' => 'integer',
        'idAliquota' => 'integer',
        'idTipoProduto' => 'integer',
        'idMedidaCompra' => 'integer',
        'idProdutoVinculado' => 'integer',
        'idProdutoIntegracao' => 'integer',
    ];
    protected $hidden = [
        'nrReducaoIcmsSubstituicaoTributaria',
        'flReduzirIcmsST',
        'vrAliquotaIpi',
        'stCST_PIS',
        'stCST_COFINS',
        'flTributarPIS',
        'flTributarCOFINS',
        'stCodigoANP',
        'nrTipoItemSped',
        'stNatRec',
        'stClassificacaoFiscal',
        'stSituacaoTributaria',
        'idAliquotaSubstituicaoTributaria',
        'idProdutoVinculado',
        'flAlterarBomba',
        'idProdutoIntegracao',
        'nrFatorConversao',
    ];

    protected $fillable = [
        'idProduto',
        'idCategoria',
        'idSetor',
        'idMedida',
        'idLocalizacao',
        'idAliquota',
        'idTipoProduto',
        'idMedidaCompra',
        'idProdutoVinculado',
        'idProdutoIntegracao',
        'idSubCategoria',
        'stProduto',
        'stProdutoAbreviado',
        'stOperador',
        'stDescricao',
        'vrUnitario',
        'vrCusto',
        'nrValidade',
        'flComissao',
        'flAtivo',
        'flControlarEstoque',
        'flPocket',
        'flPromocao',
        'flPromocaoLevePague',
        'flVendaCartao',
        'flVendaTicket',
        'flVendaSmart',
        'flRequererItemAdicional',
        'flBalanca',
        'flCupomPreVenda',
        'flDesconto',
        'flRevisaoTributaria',
        'nr10Mais',
        'dtUltimaVenda',
        'dtUltimaAlteracao',
        'dtInicioPromocao',
        'dtFimPromocao',
        'dtUltimaCompra',
        'dtAlteracao',
        'dtCriacao',
        'dtInicioPromocaoHora',
        'dtFimPromocaoHora',
        'dtRevisaoTributaria',
        'vrUnitarioPromocao',
        'vrMargemLucro',
        'vrUnitarioPromocaoHora',
        'nrFatorConversao',
        'nrTipoProduto',
        'vrUnitario2',
        'nrNCM',
        'flPromocaoHora',
        'stCest',
        'medida',
        'setor',
        'aliquota',
        'categoria',
        'subcategoria',
        'ficha',
        'stOperadorRevisaoTributaria'
    ];

    protected $appends = [
        'code',
        'codes'
    ];

    /**
     * Create a new factory instance for the model.
     *
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    protected static function newFactory()
    {
        return ProductFactory::new();
    }

    public function getDtInicioPromocaoHora()
    {
        return Carbon::parse($this->dtInicioPromocaoHora)->format('H:i');
    }

    public function getDtFimPromocaoHora()
    {
        return Carbon::parse($this->dtFimPromocaoHora)->format('H:i');
    }

    public function categoria()
    {
        return $this->belongsTo(Categoria::class, 'idCategoria');
    }

    public function codigos()
    {
        return $this->hasMany(Code::class, 'idProduto');
    }
    public function perguntas()
    {
        return $this->belongsToMany(Pergunta::class, 'prd_ProdutosPerguntas', 'idProduto', 'idPergunta');
    }


    public function getCodesAttribute()
    {
        return $this->codigos()->get()->map(function ($value, $key) {
            return $value->idCodigo;
        });
    }

    public function getCodeAttribute()
    {
        return $this->codigos()->min('idCodigo');
    }

    public function medida()
    {
        return $this->belongsTo(Measure::class, 'idMedida');
    }

    public function aliquota()
    {
        return $this->belongsTo(Aliquota::class, 'idAliquota');
    }

    public function setor()
    {
        return $this->belongsTo(Sector::class, 'idSetor');
    }

    public function stock()
    {
        return $this->hasMany(StockBalance::class, 'idProduto');
    }

    public function subcategoria()
    {
        return $this->belongsTo(SubCategoria::class, 'idCategoria', 'idCategoria')
            ->where('idSubCategoria', '=', $this->idSubCategoria);
    }

    public function composites()
    {
        return $this->hasMany(ProductComposite::class, 'idProdutoPrincipal', 'idProduto');
    }

    public function nutritional()
    {
        return $this->hasMany(Nutritional::class, 'idProduto', 'idProduto');
    }

    public function ficha()
    {
        return $this->belongsTo(FichaFornecedor::class, 'idProduto', 'idProduto');
    }

    public function promoLevePague()
    {
        return $this->hasOne(PromocaoLevePague::class, 'idProduto', 'idProduto');
    }
}
