<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Requests\Nati\ConfigCreateRequest;
use App\Services\Nati\ConfigService;
use Illuminate\Support\Facades\Cache;

class ConfigController extends Controller
{
    protected $service;

    public function __construct(ConfigService $service)
    {
        $this->service = $service;
    }

    public function index()
    {
        try {
            if (Cache::has('produtoConfig')){
                return Cache::get('produtoConfig');
            }else {
                $configs = $this->service->all()->first();

                $res = [
                    "alteracao" => $configs->flDtAlteracao,
                    "aliquota" => $configs->flAliquota,
                    "categoria" => $configs->flCategoria,
                    "codigo" => $configs->flCodigo,
                    "descricao" => $configs->flDesc,
                    "id" => $configs->flIdProduto,
                    "medida" => $configs->flMedidaVenda,
                    "ncm" => $configs->flNCM,
                    "setor" => $configs->flSetor,
                    "subcategoria" => $configs->flSubCategoria,
                    "preco" => $configs->flVrVenda,
                    "descricao" => $configs->flDescAbr,
                    "descricaoLonga" => $configs->flDesc,
                ];
                Cache::put('produtoConfig', $res, 1440);
                return response()->json($res);
            }
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function config(ConfigCreateRequest $request)
    {
        try {
            $response = $this->service->config($request->all());
            return response()->json(['data' => $response], 201);

        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => $e->getMessage()], 400);
        }
    }
}
