<?php

namespace App\Http\Controllers\Financeiro;

use App\Http\Controllers\Controller;
use App\Services\Financeiro\ContasAPagarService;
use Illuminate\Http\Request;
use App\Http\Requests\Financeiro\ContaAPagarUpdateRequest;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\Financeiro\LancamentosCreateRequest;


class ContasAPagarController extends Controller
{
    protected $service;

    public function __construct(ContasAPagarService $service)
    {
        $this->service = $service;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
        try {
            $lancamentos = $this->service->get();

            return response()->json($lancamentos);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function getLancamento(Request $request)
    {
        try {
            $lancamento = $this->service->getLancamento($request);

            return response()->json($lancamento);
        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  LancamentosCreateRequest $request
     *
     * @return \Illuminate\Http\Response
     */

    public function find(Request $request)
    {
        try {
            $lancamento = $this->service->find($request);

            return response()->json($lancamento);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function store(LancamentosCreateRequest $request)
    {
        try {
            $contasReceber = $this->service->insert($request->all());
            return response()->json([
                'message' => 'Contas a Pagar created',
                'data' => $contasReceber
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }




    public function createFromExpense(LancamentosCreateRequest $request)
    {
        try {
            $contasReceber = $this->service->createFromExpense($request->all());
            return response()->json([
                'message' => 'Contas a Pagar created',
                'data' => $contasReceber
            ]);
        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }

    public function view($idContasPagar, $idFornecedor)
    {
        try {
            $contasReceber = $this->service->getById($idContasPagar, $idFornecedor);

            return response()->json($contasReceber);
        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }

    public function setBaixa(ContaAPagarUpdateRequest $request, $idContasPagar, $idFornecedor)
    {

        try {
            $response = $this->service->setBaixa($request->all(), $idContasPagar, $idFornecedor);
            return response()->json([
                'message' => 'Contas a Receber Update',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }

    public function selectBaixa(Request $request)
    {

        try {
            $response = $this->service->selectBaixa($request->all());
            return response()->json([
                'message' => 'Lançamentos Editado com sucesso',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }


    public function estorno($idContasPagar, $idFornecedor)
    {
        try {
            $response = $this->service->estorno($idContasPagar, $idFornecedor);
            return response()->json([
                'message' => 'Contas a Receber Update',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }

    public function atualizar(ContaAPagarUpdateRequest $request, $idContasPagar, $idFornecedor)
    {

        try {
            $response = $this->service->atualizar($request->all(), $idContasPagar, $idFornecedor);
            return response()->json([
                'message' => 'Contas a Receber Update',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function delete($idContasPagar, $idFornecedor)
    {
        try {
            $response = $this->service->delete($idContasPagar, $idFornecedor);
            return response()->json([
                'message' => 'Conta Receber removida',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }
}
