<?php

namespace App\Http\Controllers\Financeiro;

use App\Entities\Financeiro\Grupo;
use App\Entities\Financeiro\SubGrupo;
use App\Http\Controllers\Controller;
use App\Http\Requests\GrupoCreateRequest;
use App\Http\Requests\GrupoUpdateRequest;
use App\Services\GrupoService;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Prettus\Validator\Exceptions\ValidatorException;


class GruposController extends Controller
{


    protected $service;


    public function __construct(GrupoService $service)
    {
        $this->service = $service;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
        try {
            $grupos = $this->service->get();

            return response()->json($grupos);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param GrupoCreateRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(GrupoCreateRequest $request)
    {
        try {
            $grupo = $this->service->insert($request->all());
            return response()->json([
                'message' => 'grupo created',
                'data' => $grupo
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }

    public function addSubgrupo(Request $request, $id)
    {
        try {
            $response = $this->service->addSubgrupo($request->all(), $id);
            return response()->json($response, 201);

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);

        } catch (ValidatorException $e) {

            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 400);
        }
    }

    public function removeSubgrupo($idGrupo, $idSubgrupo)
    {
        try {
            $sub = SubGrupo::where('idCategoriaConta', $idGrupo)->where('idTipoConta', $idSubgrupo)->first();
            $sub->delete();
            return response()->json([
                'message' => 'subgrupo deletado',
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id)
    {
        $grupo = $this->service->getById($id);
        return response()->json($grupo);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param GrupoUpdateRequest $request
     * @param string $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(GrupoUpdateRequest $request, $id)
    {
        try {
            $response = $this->service->update($request->all(), $id);
            return response()->json([
                'message' => 'grupo Update',
                'data' => $response
            ]);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 500);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy($id)
    {
        $response = $this->service->delete($id);

        if ($response) return response()->json(['message' => 'grupo deleted']);
        else return response()->json(['message' => 'Erro, grupo com sub-grupo vinculado'], 500);

    }
}
