<?php

namespace App\Http\Controllers\Financeiro;

use App\Services\Financeiro\TiposPagamentoService;
use Illuminate\Routing\Controller;

class TiposPagamentoController extends Controller
{
    private $service;

    public function __construct(TiposPagamentoService $service)
    {
        $this->service = $service;
    }

    public function index()
    {
        try {
            return response()->json($this->service->getAll());
        } catch (Exception $exception) {
            return response()->json([
                "error" => true,
                "message" => $exception->getMessage()
            ], 404);
        }
    }
}
