<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Entities\KdsDisplay;

class KdsDisplayController extends Controller
{
      /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $kdsDisplays = KdsDisplay::all();
        return response()->json($kdsDisplays);
    }
    public function getDevice($deviceId)
    {
        $kdsDisplays = KdsDisplay::where('idDevice', $deviceId)->first();
        return response()->json($kdsDisplays);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'idDevice' => 'required|integer',
            'tempoAlerta' => 'nullable|integer',
            'tipoVisualizacao' => 'nullable|string|max:100',
            'exibirMesa' => 'nullable|boolean',
            'exibirComanda' => 'nullable|boolean',
            'exibirAtendente' => 'nullable|boolean',
            'exibirTerminal' => 'nullable|boolean',
            'exibirTempoPreparo' => 'nullable|boolean',
            'idSetor' => 'nullable',
            'tamanhoPedido' => 'nullable|string'
        ]);

        $kdsDisplay = KdsDisplay::create($validated);
        return response()->json($kdsDisplay, 201);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Entities\KdsDisplay  $kdsDisplay
     * @return \Illuminate\Http\Response
     */
    public function show(KdsDisplay $kdsDisplay)
    {
        return response()->json($kdsDisplay);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Entities\KdsDisplay  $kdsDisplay
     * @return \Illuminate\Http\Response
     */
    public function createOrUpdate(Request $request)
    {
        $validated = $request->validate([
            'idDevice' => 'required|string',
            'tempoAlerta' => 'nullable|integer',
            'tipoVisualizacao' => 'nullable|string|max:100',
            'exibirMesa' => 'nullable|boolean',
            'exibirComanda' => 'nullable|boolean',
            'exibirAtendente' => 'nullable|boolean',
            'exibirTerminal' => 'nullable|boolean',
            'exibirTempoPreparo' => 'nullable|boolean',
            'idSetor' => 'nullable',
            'tamanhoPedidos' => 'nullable|string'

        ]);

        $kdsDisplay = KdsDisplay::where('idDevice', $validated['idDevice'])->first();
        if($kdsDisplay) {
            $kdsDisplay->update($validated);
        }

        if(!$kdsDisplay) {
            KdsDisplay::create($validated);
        }
        return response()->json($validated);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Entities\KdsDisplay  $kdsDisplay
     * @return \Illuminate\Http\Response
     */
    public function destroy(KdsDisplay $kdsDisplay)
    {
        $kdsDisplay->delete();
        return response()->json(null, 204);
    }
}
