<?php

namespace App\Http\Controllers;

use App\Http\Requests\MasterUpdateRequest;
use App\Services\MasterService;
use App\Validators\MasterValidator;
use Exception;
use Illuminate\Http\JsonResponse;


class MasterController extends Controller
{
    protected $service;
    protected $validator;

    /**
     * MasterController constructor.
     * @param MasterService   $service
     * @param MasterValidator $validator
     */
    public function __construct(MasterService $service, MasterValidator $validator)
    {
        $this->service = $service;
        $this->validator = $validator;
    }

    /**
     * @return JsonResponse
     */
    public function index()
    {
        try {
            $master = $this->service->get();
            return response()->json($master);
        } catch (Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    /**
     * @return JsonResponse
     */
    public function info()
    {
        try {
            $master = $this->service->get();
            $res = [
                "name" => $master->stCliente
            ];
            return response()->json($res);
        } catch (Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    /**
     * @param MasterUpdateRequest $request
     * @param string              $id
     * @return JsonResponse
     */
    public function update(MasterUpdateRequest $request, string $id)
    {
        if($request['stMarketing'] == null) {
            $request['stMarketing'] = 'Obrigado e volte sempre';
        }
        try {
            $response = $this->service->update($request->all(), $id);
            return response()->json(['data' => $response]);
        } catch (\Exception $exception){
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }

    public function updateSubAccountToken(string $id, $dealer)
    {
        $token = '';
        if($dealer === 'ARCNET') {
            $token = '8CCCFC05D54C31B8863C28707010E7BC0D723C8171B2500B069D1DBF94BA9DB3';

        };

        if($dealer === 'EDU TECSYSTEM') {
            $token = 'EF60065FC408B36EDFB8605BA4BC20FAF0E76339A828876C5AE8EACE78E581E9';
        };

        if($dealer === 'HOTTANET AUTOMAÇÃO') {
            $token = 'A7B1E433642F200F2D39AB465AC9FBE615ED595108299F8B931288BF1C1EF70D';
        };

        if($dealer === 'EBAC AUTOMAÇÃO') {
            $token = '09EE7092F7F0EEAAD1D4A1B9879BD2566325E6AB26EE09B34EABDCE3B4D46CE3';
        };

        if($dealer === 'JGS AUTOMAÇÃO') {
            $token = '9826A08005D18340C81551D145694A67E8B10B8E4003E79ED1FCEFCB91E39A21';
        };

        if($dealer === 'AMÉRICO AUTOMAÇÃO') {
            $token = 'EF3F25BF807729182BE6339B7C5E18187BC826BF0922CC8D4D7EA6947F6F5015';
        };

        if($dealer === 'CARLOS') {
            $token = '529F0BE7FD1A8BCB19DA8A52F2D06CCAE346BB31AE4872151B501DC5ACD4F330';
        }

        try {
            $response = $this->service->updateToken($token, $id);
            return response()->json(['data' => $response]);
        } catch (\Exception $exception){
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }
}
